/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparatorUtil {
    private ComparatorUtil() {
    }

    @NotNull
    public static <Type, Aspect> Comparator<Type> compareBy(@NotNull Function<? super Type, ? extends Aspect> aspect, @NotNull Comparator<? super Aspect> comparator) {
        return (element1, element2) -> comparator.compare((Object)aspect.apply((Object)element1), (Object)aspect.apply((Object)element2));
    }

    @NotNull
    public static <T extends Comparable<? super T>> T max(@NotNull T o1, @NotNull T o2) {
        return o1.compareTo(o2) >= 0 ? o1 : o2;
    }

    @NotNull
    public static <T extends Comparable<? super T>> T min(@NotNull T o1, @NotNull T o2) {
        return o1.compareTo(o2) >= 0 ? o2 : o1;
    }

    public static <T> boolean equalsNullable(@Nullable T a, @Nullable T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

