/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(@NotNull HashingStrategy<? super K> strategy) {
        return new ConcurrentWeakHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentMap<@NotNull String, @NotNull V> createConcurrentWeakCaseInsensitiveMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.caseInsensitive());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap() {
        return new java.util.WeakHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new WeakHashMap(initialCapacity, loadFactor, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return CollectionFactory.createWeakMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueIdentityMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.identity());
    }

    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(@NotNull List<? extends CharSequence> items) {
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(int capacity, float loadFactory, boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(capacity, loadFactory, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(@NotNull Collection<String> items) {
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(int initialSize) {
        return new ObjectOpenCustomHashSet(initialSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(int expectedSize) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(@NotNull Map<String, V> source) {
        return new Object2ObjectOpenCustomHashMap(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet<String>(expectedSize) : new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet<String>(paths) : new ObjectOpenCustomHashSet(paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(String @NotNull [] paths, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet<String>(Arrays.asList(paths)) : new ObjectOpenCustomHashSet((Object[])paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        return CollectionFactory.createFilePathSet(paths, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashMap(expectedSize) : new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedSet() : new ObjectLinkedOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedMap() : new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintLinkedMap() {
        return new Object2ObjectLinkedOpenHashMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected) {
        return new Object2ObjectOpenHashMap(expected);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(@NotNull Map<? extends K, ? extends V> map) {
        return new Object2ObjectOpenHashMap(map);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected, float loadFactor) {
        return new Object2ObjectOpenHashMap(expected, loadFactor);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintLinkedSet() {
        return new ObjectLinkedOpenHashSet();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet() {
        return new ObjectOpenHashSet();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        return new ObjectOpenHashSet(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    static <K, V> @NotNull Map<@NotNull K, V> createSoftMap(@NotNull HashingStrategy<? super K> strategy) {
        return new SoftHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public static void trimMap(@NotNull Map<?, ?> map) {
        if (map instanceof Object2ObjectOpenHashMap) {
            ((Object2ObjectOpenHashMap)map).trim();
        } else if (map instanceof Object2ObjectOpenCustomHashMap) {
            ((Object2ObjectOpenCustomHashMap)map).trim();
        }
    }

    public static void trimSet(@NotNull Set<?> set) {
        if (set instanceof ObjectOpenHashSet) {
            ((ObjectOpenHashSet)set).trim();
        } else if (set instanceof ObjectOpenCustomHashSet) {
            ((ObjectOpenCustomHashSet)set).trim();
        }
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        return new Object2ObjectOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    private static <K> Hash.Strategy<K> adaptStrategy(final @NotNull HashingStrategy<? super K> strategy) {
        return new FastUtilHashingStrategies.SerializableHashStrategy<K>(){

            public int hashCode(@Nullable K o) {
                return strategy.hashCode(o);
            }

            public boolean equals(@Nullable K a, @Nullable K b) {
                return strategy.equals(a, b);
            }
        };
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(int expected, @NotNull HashingStrategy<? super K> strategy) {
        return new Object2ObjectOpenCustomHashMap(expected, CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        return new ObjectOpenCustomHashSet(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createLinkedCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        return new ObjectLinkedOpenCustomHashSet(CollectionFactory.adaptStrategy(strategy));
    }
}

