/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new HashMap();
    private final Map<V, List<K>> myValueToKeysMap = new HashMap<V, List<K>>();

    @Override
    public final V put(K key, V value) {
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            List<K> array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
            if (array.isEmpty()) {
                this.myValueToKeysMap.remove(oldValue);
            }
        }
        this.myValueToKeysMap.computeIfAbsent((List)value, (Function<List, List<Object>>)((Function<Object, List>)__ -> new SmartList())).add(key);
        return oldValue;
    }

    @Override
    public final void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public final List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    @Override
    @NotNull
    public final Set<K> keySet() {
        return this.myKeyToValueMap.keySet();
    }

    @Override
    public final int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public final V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    public final void removeValue(V v) {
        List<K> ks = this.myValueToKeysMap.remove(v);
        if (ks != null) {
            for (K k : ks) {
                this.myKeyToValueMap.remove(k);
            }
        }
    }

    @Override
    public final V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public final void putAll(@NotNull Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        return this.myValueToKeysMap.keySet();
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.myKeyToValueMap.entrySet();
    }

    public final String toString() {
        return this.myKeyToValueMap.toString();
    }
}

