/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CancellationCallable;
import com.intellij.openapi.progress.CancellationFutureTask;
import com.intellij.openapi.progress.CancellationRunnable;
import com.intellij.openapi.progress.PeriodicCancellationRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class Propagation {
    @TestOnly
    static void runTestWithPropagationEnabled(@NotNull Runnable runnable) {
        boolean propagateThreadContext = Holder.propagateThreadContext;
        boolean propagateThreadCancellation = Holder.propagateThreadCancellation;
        Holder.propagateThreadContext = true;
        Holder.propagateThreadCancellation = true;
        try {
            runnable.run();
        }
        finally {
            Holder.propagateThreadContext = propagateThreadContext;
            Holder.propagateThreadCancellation = propagateThreadCancellation;
        }
    }

    private Propagation() {
    }

    static boolean propagateThreadContext() {
        return Holder.propagateThreadContext;
    }

    public static boolean propagateCancellation() {
        return Holder.propagateThreadCancellation;
    }

    @NotNull
    static Runnable handleCommand(@NotNull Runnable command) {
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            return Propagation.handleContext(new CancellationRunnable(childJob, command));
        }
        return Propagation.handleContext(command);
    }

    @NotNull
    static <V> FutureTask<V> handleTask(@NotNull Callable<V> callable) {
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            return new CancellationFutureTask<V>((Job)childDeferred, Propagation.handleContext(cancellationCallable));
        }
        return new FutureTask<V>(Propagation.handleContext(callable));
    }

    @NotNull
    static <V> SchedulingWrapper.MyScheduledFutureTask<V> handleScheduledFutureTask(@NotNull SchedulingWrapper wrapper, @NotNull Callable<V> callable, long ns) {
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableDeferred childDeferred = CompletableDeferredKt.CompletableDeferred((Job)currentJob);
            CancellationCallable<V> cancellationCallable = new CancellationCallable<V>(childDeferred, callable);
            SchedulingWrapper schedulingWrapper = wrapper;
            Objects.requireNonNull(schedulingWrapper);
            return schedulingWrapper.new SchedulingWrapper.CancellationScheduledFutureTask<V>((Job)childDeferred, Propagation.handleContext(cancellationCallable), ns);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<V>(Propagation.handleContext(callable), ns);
    }

    @NotNull
    static SchedulingWrapper.MyScheduledFutureTask<?> handlePeriodicScheduledFutureTask(@NotNull SchedulingWrapper wrapper, @NotNull Runnable runnable, long ns, long period) {
        if (Propagation.propagateCancellation()) {
            Job currentJob = Cancellation.currentJob();
            CompletableJob childJob = JobKt.Job((Job)currentJob);
            PeriodicCancellationRunnable cancellationRunnable = new PeriodicCancellationRunnable(childJob, runnable);
            SchedulingWrapper schedulingWrapper = wrapper;
            Objects.requireNonNull(schedulingWrapper);
            return schedulingWrapper.new SchedulingWrapper.CancellationScheduledFutureTask((Job)childJob, Propagation.handleContext(cancellationRunnable), ns, period);
        }
        SchedulingWrapper schedulingWrapper = wrapper;
        Objects.requireNonNull(schedulingWrapper);
        return schedulingWrapper.new SchedulingWrapper.MyScheduledFutureTask<Object>(Propagation.handleContext(runnable), null, ns, period);
    }

    @NotNull
    public static Runnable handleContext(@NotNull Runnable runnable) {
        if (Propagation.propagateThreadContext()) {
            return ThreadContext.captureThreadContext(runnable);
        }
        return runnable;
    }

    @NotNull
    private static <V> Callable<V> handleContext(@NotNull Callable<V> callable) {
        if (Propagation.propagateThreadContext()) {
            return ThreadContext.captureThreadContext(callable);
        }
        return callable;
    }

    static class Holder {
        private static boolean propagateThreadContext = Registry.is("ide.propagate.context");
        private static boolean propagateThreadCancellation = Registry.is("ide.propagate.cancellation");

        Holder() {
        }
    }
}

