/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class BoundedScheduledExecutorService
extends SchedulingWrapper {
    BoundedScheduledExecutorService(@NotNull @NonNls String name, @NotNull ExecutorService backendExecutor, int maxThreads) {
        super(new BoundedTaskExecutor(name, backendExecutor, maxThreads, true), ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).delayQueue);
        assert (!(backendExecutor instanceof ScheduledExecutorService)) : "backendExecutor is already ScheduledExecutorService: " + backendExecutor;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cancelAndRemoveTasksFromQueue();
        this.backendExecutorService.shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return ContainerUtil.concat(super.shutdownNow(), this.backendExecutorService.shutdownNow());
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown() && this.backendExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.backendExecutorService.isTerminated();
    }
}

