/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ContextPropagatingExecutor;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppScheduledExecutorService
extends SchedulingWrapper {
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private final MyThreadFactory myCountingThreadFactory;

    @NotNull
    static ScheduledExecutorService getInstance() {
        return Holder.INSTANCE;
    }

    AppScheduledExecutorService(@NotNull String name, long keepAliveTime, @NotNull TimeUnit unit) {
        super(new BackendThreadPoolExecutor(new MyThreadFactory(), keepAliveTime, unit), new AppDelayQueue());
        this.myName = name;
        this.myCountingThreadFactory = (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
        this.myCountingThreadFactory.setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.error();
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        return ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdownNow());
    }

    void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    @TestOnly
    public String statistics() {
        return this.myName + " threads created counter = " + this.myCountingThreadFactory.counter;
    }

    @TestOnly
    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    @TestOnly
    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
    }

    @NotNull
    public static Thread getPeriodicTasksThread() {
        return Holder.INSTANCE.delayQueue.getThread();
    }

    @TestOnly
    void waitForLowMemoryWatcherManagerInit(int timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.myLowMemoryWatcherManager.waitForInitComplete(timeout, unit);
    }

    @NotNull
    static Runnable handleCommand(@NotNull Runnable command) {
        if (command instanceof FutureTask) {
            return command;
        }
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return command;
        }
        return Propagation.handleCommand(command);
    }

    @NotNull
    static <T> FutureTask<T> handleTask(Callable<T> callable) {
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return new FutureTask<T>(callable);
        }
        return Propagation.handleTask(callable);
    }

    static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor
    implements ContextPropagatingExecutor {
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory, long keepAliveTime, @NotNull TimeUnit unit) {
            super(1, Integer.MAX_VALUE, keepAliveTime, unit, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        public void executeRaw(@NotNull Runnable command) {
            super.execute(command);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.executeRaw(AppScheduledExecutorService.handleCommand(command));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return this.newTaskFor(Executors.callable(runnable, value));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return AppScheduledExecutorService.handleTask(callable);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null && !(t instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> superShutdownNow() {
            return super.shutdownNow();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return AppScheduledExecutorService.error();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static final class MyThreadFactory
    extends CountingThreadFactory {
        private BiConsumer<? super Thread, ? super Runnable> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setName(AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            BiConsumer<? super Thread, ? super Runnable> listener = this.newThreadListener;
            if (listener != null) {
                listener.accept(thread, r);
            }
            return thread;
        }

        void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }
    }

    private static final class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance", 1L, TimeUnit.MINUTES);

        private Holder() {
        }
    }
}

