/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.UrlsKt;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0007J*\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\b\b\u0002\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0007J$\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0007H\u0007J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0007H\u0007J\u001a\u0010\"\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0007J6\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0007J\"\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0007J0\u0010$\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\fH\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u0012\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0007J\u0012\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u00a8\u0006."}, d2={"Lcom/intellij/util/Urls;", "", "()V", "encodeParameters", "", "parameters", "", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "", "url1", "Lcom/intellij/util/Url;", "url2", "caseSensitive", "ignoreParameters", "equalsIgnoreParameters", "url", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "urls", "", "newFromEncoded", "newFromIdea", "", "newFromVirtualFile", "newHttpUrl", "authority", "path", "newLocalFileUrl", "newUnparsable", "string", "newUri", "scheme", "newUrl", "rawParameters", "parse", "asLocalIfNoScheme", "parseAsJavaUriWithoutParameters", "Ljava/net/URI;", "parseEncoded", "parseFromIdea", "parseUrl", "toUriWithoutParameters", "intellij.platform.ide.util.io"})
@NonNls
public final class Urls {
    @NotNull
    public static final Urls INSTANCE;

    @JvmStatic
    @NotNull
    public static final Url newUri(@Nullable String scheme, @NotNull String path) {
        return new UrlImpl(scheme, null, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String rawParameters) {
        return new UrlImpl(scheme, authority, path, rawParameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @NotNull String path, @NotNull Map<String, String> parameters) {
        Map<String, String> map = parameters;
        if (!map.isEmpty()) {
            StringBuilder result = new StringBuilder().append('?');
            Urls.encodeParameters(parameters, result);
            return new UrlImpl(scheme, authority, path, result.toString());
        }
        return new UrlImpl(scheme, authority, path);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void encodeParameters(@NotNull Map<String, String> parameters, @NotNull StringBuilder result) {
        int initialSize = result.length();
        Object object = parameters;
        for (Map.Entry<String, String> entry : object.entrySet()) {
            void name;
            Object object2 = entry;
            object = object2.getKey();
            object2 = entry;
            String value = object2.getValue();
            if (result.length() != initialSize) {
                result.append('&');
            }
            result.append(URLUtil.encodeURIComponent((String)name));
            object2 = value;
            if (object2 == null || object2.length() == 0) continue;
            result.append('=').append(URLUtil.encodeURIComponent(value));
        }
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        return new LocalFileUrl(FileUtilRt.toSystemIndependentName((String)path));
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file2) {
        return new LocalFileUrl(file2.getPath());
    }

    @JvmStatic
    @NotNull
    public static final Url newFromEncoded(@NotNull String url) {
        Url url2 = Urls.parse(url, false);
        if (url2 == null) {
            throw (Throwable)new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseEncoded(@NotNull String url) {
        return Urls.parse(url, false);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        return Urls.newUrl("http", authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters) {
        return new UrlImpl("http", authority, path, parameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @Nullable String path) {
        return new UrlImpl(scheme, authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newFromIdea(@NotNull CharSequence url) {
        Url url2 = Urls.parseFromIdea(url);
        if (url2 == null) {
            throw (Throwable)new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseFromIdea(@NotNull CharSequence url) {
        CharSequence charSequence = url;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element = charSequence.charAt(i);
            switch (element) {
                case ':': {
                    return INSTANCE.parseUrl(url);
                }
                case '/': 
                case '\\': {
                    return Urls.newLocalFileUrl(((Object)url).toString());
                }
            }
        }
        return Urls.newLocalFileUrl(((Object)url).toString());
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        CharSequence charSequence = url;
        return charSequence.length() == 0 ? null : (asLocalIfNoScheme && !URLUtil.containsScheme(url) ? Urls.newLocalFileUrl(url) : INSTANCE.parseUrl(VfsUtilCore.toIdeaUrl(url, true)));
    }

    @JvmStatic
    @Nullable
    public static final URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        Url url2 = INSTANCE.parseUrl(url);
        if (url2 == null) {
            return null;
        }
        Url asUrl = url2;
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Urls.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("Cannot parse: " + url, e);
            return null;
        }
    }

    private final Url parseUrl(CharSequence url) {
        boolean hasUrlSeparator;
        String string2;
        String string3;
        String it;
        CharSequence urlToParse = StringsKt.startsWith$default((CharSequence)url, (CharSequence)"jar:file://", (boolean)false, (int)2, null) ? url.subSequence("jar:".length(), url.length()) : url;
        Matcher matcher = UrlsKt.access$getURI_PATTERN$p().matcher(urlToParse);
        if (!matcher.matches()) {
            return null;
        }
        Object scheme = matcher.group(1);
        if (urlToParse != url) {
            scheme = "jar:" + (String)scheme;
        }
        String string4 = matcher.group(3);
        if (string4 != null) {
            String string5;
            it = string5 = string4;
            boolean bl = false;
            CharSequence charSequence = it;
            string3 = !(charSequence.length() == 0) ? string5 : null;
        } else {
            string3 = null;
        }
        String authority = string3;
        String string6 = matcher.group(4);
        if (string6 != null) {
            String it2 = it = string6;
            boolean bl = false;
            CharSequence charSequence = it2;
            string2 = !(charSequence.length() == 0) ? it : null;
        } else {
            string2 = null;
        }
        String path = string2;
        CharSequence charSequence = matcher.group(2);
        boolean bl = hasUrlSeparator = !(charSequence == null || charSequence.length() == 0);
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme) || !hasUrlSeparator) {
            path = path == null ? authority : authority + path;
            String string7 = authority = hasUrlSeparator ? "" : null;
        }
        if (path != null && (!((charSequence = (CharSequence)authority) == null || charSequence.length() == 0) || Intrinsics.areEqual((Object)"file", (Object)scheme))) {
            path = FileUtilRt.toCanonicalPath((String)path, (char)'/', (boolean)false);
        }
        return new UrlImpl((String)scheme, authority, path, matcher.group(5));
    }

    @JvmStatic
    @NotNull
    public static final Url newFromVirtualFile(@NotNull VirtualFile file2) {
        Url url;
        if (file2.isInLocalFileSystem()) {
            url = Urls.newUri(file2.getFileSystem().getProtocol(), file2.getPath());
        } else {
            url = INSTANCE.parseUrl(file2.getUrl());
            if (url == null) {
                url = Urls.newUnparsable(file2.getPath());
            }
        }
        return url;
    }

    @JvmStatic
    @NotNull
    public static final Url newUnparsable(@NotNull String string2) {
        return new UrlImpl(null, null, string2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls, boolean caseSensitive) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = urls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Url it = (Url)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.equals(url, it, caseSensitive, true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean equalsIgnoreParameters$default(Url url, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Urls.equalsIgnoreParameters(url, collection, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls) {
        return Urls.equalsIgnoreParameters$default(url, urls, false, 4, null);
    }

    public final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file2) {
        boolean bl;
        if (file2.isInLocalFileSystem()) {
            bl = url.isInLocalFileSystem() && StringsKt.equals((String)url.getPath(), (String)file2.getPath(), (!file2.isCaseSensitive() ? 1 : 0) != 0);
        } else if (url.isInLocalFileSystem()) {
            bl = false;
        } else {
            Url url2 = this.parseUrl(file2.getUrl());
            bl = url2 != null ? url2.equalsIgnoreParameters(url) : false;
        }
        return bl;
    }

    public final boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url o1 = ignoreParameters ? url1.trimParameters() : url1;
        Url o2 = ignoreParameters ? url2.trimParameters() : url2;
        return caseSensitive ? Intrinsics.areEqual((Object)o1, (Object)o2) : o1.equalsIgnoreCase(o2);
    }

    @JvmStatic
    @NotNull
    public static final URI toUriWithoutParameters(@NotNull Url url) {
        URI uRI;
        try {
            boolean inLocalFileSystem = url.isInLocalFileSystem();
            String scheme = inLocalFileSystem ? "file" : url.getScheme();
            String authority = inLocalFileSystem ? "" : url.getAuthority();
            String externalPath = inLocalFileSystem && SystemInfoRt.isWindows && url.getPath().charAt(0) != '/' ? "/" + url.getPath() : url.getPath();
            uRI = new URI(scheme, authority, externalPath, null, null);
        }
        catch (URISyntaxException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return uRI;
    }

    private Urls() {
    }

    static {
        Urls urls;
        INSTANCE = urls = new Urls();
    }
}

