/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path) {
        this(scheme, authority, path, null);
    }

    UrlImpl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = StringUtil.notNullize(path);
        this.parameters = StringUtil.nullize(parameters);
    }

    @Override
    @NotNull
    public Url resolve(@NotNull String subPath) {
        return new UrlImpl(this.scheme, this.authority, (String)(this.path.isEmpty() ? subPath : this.path + "/" + subPath), this.parameters);
    }

    @Override
    @NotNull
    public Url addParameters(@NotNull Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        if (this.parameters == null) {
            builder.append('?');
        } else {
            builder.append(this.parameters);
            builder.append('&');
        }
        Urls.encodeParameters(parameters, builder);
        return new UrlImpl(this.scheme, this.authority, this.path, builder.toString());
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences(this.path);
        }
        return this.decodedPath;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Override
    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String toDecodedForm() {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            builder.append(this.scheme);
            if (this.authority == null) {
                builder.append(':');
            } else {
                builder.append("://");
            }
            if (this.authority != null) {
                builder.append(this.authority);
            }
        }
        builder.append(this.getPath());
        if (this.parameters != null) {
            builder.append(this.parameters);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String toExternalForm() {
        Object result;
        if (this.externalForm != null) {
            return this.externalForm;
        }
        if ((this.authority == null || !this.path.isEmpty() && this.path.charAt(0) != '/') && !this.isInLocalFileSystem()) {
            return this.toDecodedForm();
        }
        Object object = result = StringUtil.isEmpty(this.authority) && StringUtil.isEmpty(this.path) ? this.scheme + "://" : Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result = (String)result + this.parameters;
        }
        this.externalForm = result;
        return result;
    }

    @Override
    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            return this;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        return this.withoutParameters;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals(this.scheme, url.scheme) && StringUtil.equals(this.authority, url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals(this.parameters, url.parameters);
    }

    @Override
    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase(this.scheme, url.scheme) && StringUtil.equalsIgnoreCase(this.authority, url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase(this.parameters, url.parameters);
    }

    @Override
    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result = 31 * result + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result;
    }

    private static int stringHashCode(@Nullable CharSequence string2, boolean caseSensitive) {
        return string2 == null ? 0 : (caseSensitive ? string2.hashCode() : StringUtil.stringHashCodeInsensitive(string2));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    @Override
    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }

    @Override
    @NotNull
    public Url removeParameter(@NotNull String name) {
        StringBuilder result = new StringBuilder();
        String parameters = this.parameters;
        if (parameters == null) {
            return this;
        }
        if (parameters.startsWith("?")) {
            parameters = StringUtil.trimStart(parameters, "?");
            result.append("?");
        }
        boolean added = false;
        for (String s : parameters.split("&")) {
            String currentName = ContainerUtil.getFirstItem(StringUtil.split(s, "="));
            if (StringUtil.equals(currentName, name)) continue;
            if (added) {
                result.append("&");
            }
            result.append(s);
            added = true;
        }
        return new UrlImpl(this.scheme, this.authority, this.path, result.toString());
    }
}

