/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class UniqueResultsQuery<T, M>
extends AbstractQuery<T> {
    @NotNull
    private final Query<? extends T> myOriginal;
    private final HashingStrategy<? super M> myHashingStrategy;
    @NotNull
    private final Function<? super T, ? extends M> myMapper;

    public UniqueResultsQuery(@NotNull Query<? extends T> original) {
        this(original, Functions.identity());
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull HashingStrategy<? super M> hashingStrategy) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = Functions.identity();
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull Function<? super T, ? extends M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = null;
        this.myMapper = mapper;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        return UniqueResultsQuery.delegateProcessResults(this.myOriginal, new MyProcessor(this.createSet(), consumer));
    }

    @NotNull
    private Set<M> createSet() {
        if (this.myHashingStrategy == null) {
            return Collections.synchronizedSet(new HashSet());
        }
        return Collections.synchronizedSet(CollectionFactory.createCustomHashingStrategySet(this.myHashingStrategy));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.myOriginal.forEachAsync(new MyProcessor(this.createSet(), consumer));
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private final class MyProcessor
    implements Processor<T> {
        private final Set<? super M> myProcessedElements;
        private final Processor<? super T> myConsumer;

        MyProcessor(@NotNull Set<? super M> processedElements, Processor<? super T> consumer) {
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(T t) {
            ProgressManager.checkCanceled();
            Object m = UniqueResultsQuery.this.myMapper.fun(t);
            if (this.myProcessedElements.contains(m)) {
                return true;
            }
            boolean result = this.myConsumer.process(t);
            this.myProcessedElements.add(m);
            return result;
        }
    }
}

