/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EDT;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SlowOperations {
    private static final Logger LOG = Logger.getInstance(SlowOperations.class);
    public static final String ACTION_UPDATE = "action.update";
    public static final String ACTION_PERFORM = "action.perform";
    public static final String RENDERING = "rendering";
    public static final String GENERIC = "generic";
    public static final String FAST_TRACK = "  fast track  ";
    public static final String RESET = "  reset  ";
    private static int ourAlwaysAllow = -1;
    @NotNull
    private static @NotNull FList<@NotNull String> ourStack = FList.emptyList();

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if (SlowOperations.isInsideActivity(FAST_TRACK)) {
            throw new ProcessCanceledException();
        }
        if (SlowOperations.isAlwaysAllowed()) {
            return;
        }
        if (!Registry.is("ide.slow.operations.assertion", true)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !Registry.is("ide.slow.operations.assertion.write.action")) {
            return;
        }
        if (ourStack.isEmpty() && !Registry.is("ide.slow.operations.assertion.other", false)) {
            return;
        }
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (Registry.is("ide.slow.operations.assertion." + activity, true)) continue;
            return;
        }
        Throwable throwable = new Throwable();
        if (ThrowableInterner.intern(throwable) != throwable) {
            return;
        }
        LOG.error("Slow operations are prohibited on EDT. See SlowOperations.assertSlowOperationsAreAllowed javadoc.");
    }

    @ApiStatus.Internal
    public static boolean isInsideActivity(@NotNull String activityName) {
        EDT.assertIsEdt();
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (activityName != activity) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean isAlwaysAllowed() {
        if (ourAlwaysAllow == 1) {
            return true;
        }
        if (ourAlwaysAllow == 0) {
            return false;
        }
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean result = System.getenv("TEAMCITY_VERSION") != null || application.isUnitTestMode() || application.isCommandLine() || !application.isEAP() && !application.isInternal();
        ourAlwaysAllow = result ? 1 : 0;
        return result;
    }

    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        try (AccessToken ignore = SlowOperations.allowSlowOperations(GENERIC);){
            Object object = computable.compute();
            return (T)object;
        }
    }

    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        try (AccessToken ignore = SlowOperations.allowSlowOperations(GENERIC);){
            runnable.run();
        }
    }

    @NotNull
    public static AccessToken allowSlowOperations(@NotNull @NonNls String activityName) {
        if (!EDT.isCurrentThreadEdt()) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        final FList<String> prev = ourStack;
        ourStack = prev.prepend(activityName);
        return new AccessToken(){

            @Override
            public void finish() {
                ourStack = prev;
            }
        };
    }
}

