/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.JBIterableClassTraverser;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.SmartList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    private static final Logger LOG;
    private static final Object unsafe;

    private ReflectionUtil() {
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable<?> variable, @NotNull Class<?> classType) {
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    @Nullable
    public static Type resolveVariable(@NotNull TypeVariable<?> variable, @NotNull Class<?> classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtilRt.find((Object[])aClass.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type;
            Class<?> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtilRt.find((Object[])anInterface.getTypeParameters(), (Object)typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\ngenericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\nsearching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    @NotNull
    private static String declarationToString(@NotNull GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    @NotNull
    public static Class<?> getRawType(@NotNull Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type @NotNull [] getActualTypeArguments(@NotNull ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments();
    }

    @Nullable
    public static Class<?> substituteGenericType(@NotNull Type genericType, @NotNull Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find((Object[])aClass.getTypeParameters(), (Object)type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            Collections.addAll(result, clazz2.getDeclaredFields());
        }
        return result;
    }

    @NotNull
    public static Field findField(@NotNull Class<?> clazz, @Nullable Class<?> type, @NotNull @NonNls String name) throws NoSuchFieldException {
        Field result = ReflectionUtil.findFieldInHierarchy(clazz, field -> name.equals(field.getName()) && (type == null || field.getType().equals(type)));
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull @NonNls String fieldName) throws NoSuchFieldException {
        Field result = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())));
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<? super Class<?>> visited, @NotNull Predicate<? super Field> checker) {
        for (Class<?> anInterface : interfaces) {
            if (!visited.add(anInterface)) continue;
            for (Field field : anInterface.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Field field = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static void resetField(@NotNull Class<?> clazz, @Nullable(value="null means of any type") @Nullable(value="null means of any type") Class<?> type, @NotNull @NonNls String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@NotNull Object object, @NotNull @NonNls String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods, @NonNls @NotNull String name, Class<?> ... parameters) {
        for (Method method : methods) {
            if (parameters.length != method.getParameterCount() || !name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return ReflectionUtil.makeAccessible(method);
        }
        return null;
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters) {
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name, parameters));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name, Class<?> ... parameters) {
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name, parameters));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class<?> aClass, @NonNls @NotNull String name) {
        return ReflectionUtil.findFieldInHierarchy(aClass, field -> name.equals(field.getName()));
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class<?> aClass) {
        return ReflectionUtil.getClassPublicMethods(aClass, false);
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class<?> aClass, boolean includeSynthetic) {
        Method[] methods = aClass.getMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class<?> aClass) {
        return ReflectionUtil.getClassDeclaredMethods(aClass, false);
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class<?> aClass, boolean includeSynthetic) {
        Method[] methods = aClass.getDeclaredMethods();
        return includeSynthetic ? Arrays.asList(methods) : ReflectionUtil.filterRealMethods(methods);
    }

    @NotNull
    public static List<Field> getClassDeclaredFields(@NotNull Class<?> aClass) {
        Field[] fields = aClass.getDeclaredFields();
        return Arrays.asList(fields);
    }

    @NotNull
    private static List<Method> filterRealMethods(Method @NotNull [] methods) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            result.add(method);
        }
        return result;
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters) {
        Method method = ReflectionUtil.getMethod(instanceClass, methodName, parameters);
        if (method != null) {
            return method.getDeclaringClass();
        }
        while (instanceClass != null) {
            method = ReflectionUtil.getDeclaredMethod(instanceClass, methodName, parameters);
            if (method != null) {
                return method.getDeclaringClass();
            }
            instanceClass = instanceClass.getSuperclass();
        }
        return null;
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field, null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object object) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    public static <T> boolean setField(@NotNull Class<?> objectClass, Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName, T value) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.set(object, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.debug(e);
            return false;
        }
    }

    public static Type resolveVariableInHierarchy(@NotNull TypeVariable<?> variable, @NotNull Class<?> aClass) {
        Type type;
        Class<?> current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        try {
            Constructor<T> constructor = aClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            T t;
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t = ReflectionUtil.createAsDataClass(aClass)) != null) {
                return t;
            }
            ExceptionUtilRt.rethrowUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        for (Annotation annotation : aClass.getAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals("kotlin.Metadata") && !name.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors) {
                try {
                    block14: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor.getParameterCount() == 0) {
                            return (T)constructor.newInstance(new Object[0]);
                        }
                        for (Class<?> type : parameterTypes = constructor.getParameterTypes()) {
                            if (!type.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block14;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args2) {
        try {
            return constructor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Class<?> getGrandCallerClass() {
        int stackFrameCount = 3;
        return ReflectionUtil.getCallerClass(stackFrameCount + 1);
    }

    public static Class<?> getCallerClass(int stackFrameCount) {
        Class<?> callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        int depth = stackFrameCount + 1;
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(depth);
            ++depth;
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(stackFrameCount - 1);
        }
        return callerClass;
    }

    public static void copyFields(Field @NotNull [] fields, @NotNull Object from, @NotNull Object to) {
        ReflectionUtil.copyFields(fields, from, to, null);
    }

    public static boolean copyFields(Field @NotNull [] fields, @NotNull Object from, @NotNull Object to, @Nullable DifferenceFilter<?> diffFilter) {
        HashSet<Field> sourceFields = new HashSet<Field>(Arrays.asList(from.getClass().getFields()));
        boolean valuesChanged = false;
        for (Field field : fields) {
            if (!sourceFields.contains(field) || !ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            try {
                if (diffFilter != null && !diffFilter.test(field)) continue;
                ReflectionUtil.copyFieldValue(from, to, field);
                valuesChanged = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return valuesChanged;
    }

    public static <T> boolean comparePublicNonFinalFields(@NotNull T first, @NotNull T second) {
        Class<?> defaultClass = first.getClass();
        Field[] fields = defaultClass.getDeclaredFields();
        if (defaultClass != second.getClass()) {
            fields = ArrayUtil.mergeArrays(fields, second.getClass().getDeclaredFields());
        }
        for (Field field : fields) {
            if (!ReflectionUtil.isPublic(field) || ReflectionUtil.isFinal(field)) continue;
            field.setAccessible(true);
            try {
                if (Comparing.equal((Object)field.get(second), (Object)field.get(first))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static void copyFieldValue(@NotNull Object from, @NotNull Object to, @NotNull Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (!(fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.isEnum())) {
            throw new RuntimeException("Field '" + field.getName() + "' not copied: unsupported type: " + field.getType());
        }
        field.set(to, field.get(from));
    }

    private static boolean isPublic(@NotNull Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(@NotNull Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    public static Class<?> forName(@NotNull String fqn) {
        try {
            return Class.forName(fqn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static Class<?> boxType(@NotNull Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return type;
    }

    @NotNull
    public static <T, V> Field getTheOnlyVolatileInstanceFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            int modifiers = field.getModifiers();
            if (BitUtil.isSet(modifiers, 8) || !BitUtil.isSet(modifiers, 64) || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found + " and " + field);
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        return found;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Object getUnsafe() {
        return unsafe;
    }

    public static Class<?> findCallerClass(int framesToSkip) {
        return ReflectionUtilRt.findCallerClass((int)(framesToSkip + 1));
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static String dumpFields(@NotNull Class<?> objectClass, @Nullable Object object, String ... fieldNames) {
        SmartList<String> chunks = new SmartList<String>();
        for (String fieldName : fieldNames) {
            chunks.add(fieldName + "=" + ReflectionUtil.getField(objectClass, object, null, fieldName));
        }
        return String.join((CharSequence)"; ", chunks);
    }

    static {
        Class<?> unsafeClass;
        LOG = Logger.getInstance(ReflectionUtil.class);
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
    }
}

