/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QueryFactory<Result, Parameters> {
    private final List<QueryExecutor<Result, Parameters>> myExecutors = ContainerUtil.createLockFreeCopyOnWriteList();

    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.add(executor);
    }

    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> executor) {
        this.myExecutors.remove(executor);
    }

    @NotNull
    public final Query<Result> createQuery(@NotNull Parameters parameters) {
        return new ExecutorsQuery<Result, Parameters>(parameters, this.getExecutors());
    }

    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        return this.myExecutors;
    }

    public boolean hasAnyExecutors() {
        return !this.getExecutors().isEmpty();
    }

    @NotNull
    public final Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters) {
        return new UniqueResultsQuery(this.createQuery(parameters));
    }

    @NotNull
    public final <T> Query<Result> createUniqueResultsQuery(@NotNull Parameters parameters, @NotNull Function<? super Result, ? extends T> mapper) {
        return new UniqueResultsQuery<Result, T>(this.createQuery(parameters), mapper);
    }
}

