/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMappingSettings
extends AbstractPathMapper
implements Cloneable {
    @NotNull
    private List<PathMapping> myPathMappings;

    public PathMappingSettings(@Nullable List<? extends PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    private static List<PathMapping> create(@Nullable List<? extends PathMapping> mappings) {
        ArrayList<PathMapping> result = new ArrayList<PathMapping>();
        if (mappings != null) {
            for (PathMapping pathMapping : mappings) {
                if (pathMapping == null || PathMappingSettings.isAnyEmpty(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot())) continue;
                result.add(pathMapping);
            }
        }
        return result;
    }

    public PathMappingSettings() {
        this.myPathMappings = new ArrayList<PathMapping>();
    }

    @NotNull
    static String norm(@NotNull String path) {
        return FileUtil.toSystemIndependentName(path);
    }

    @NotNull
    private static String normLocal(@NotNull String path) {
        if (SystemInfo.isWindows) {
            path = StringUtil.toLowerCase(path);
        }
        return PathMappingSettings.norm(path);
    }

    @Override
    public boolean isEmpty() {
        return this.myPathMappings.isEmpty();
    }

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        String localPath = PathMappingSettings.convertToLocal(remotePath, this.myPathMappings);
        return localPath != null ? localPath : remotePath;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        String remotePath = PathMappingSettings.convertToRemote(localPath, this.myPathMappings);
        return remotePath != null ? remotePath : localPath;
    }

    public void add(@Nullable PathMapping mapping) {
        if (mapping == null) {
            return;
        }
        if (PathMappingSettings.isAnyEmpty(mapping.getLocalRoot(), mapping.getRemoteRoot())) {
            return;
        }
        this.myPathMappings.add(mapping);
    }

    public void addMapping(@Nullable String local, @Nullable String remote) {
        PathMapping mapping = new PathMapping(local, remote);
        this.add(mapping);
    }

    public void addMappingCheckUnique(@NotNull String local, @NotNull String remote) {
        PathMapping mapping = new PathMapping(local, remote);
        if (this.myPathMappings.contains(mapping)) {
            return;
        }
        this.add(mapping);
    }

    private static boolean pathEquals(@NotNull String path1, @NotNull String path2) {
        return PathMappingSettings.norm(path1).equals(PathMappingSettings.norm(path2));
    }

    @Override
    @NotNull
    protected final Collection<PathMapping> getAvailablePathMappings() {
        return Collections.unmodifiableCollection(this.myPathMappings);
    }

    @NotNull
    public List<PathMapping> getPathMappings() {
        return this.myPathMappings;
    }

    public void setPathMappings(@Nullable List<? extends PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    public static String mapToLocal(@NotNull String path, @Nullable String remoteRoot, @Nullable String localRoot) {
        String remotePrefix;
        if (PathMappingSettings.isAnyEmpty(localRoot, remoteRoot)) {
            return path;
        }
        if (PathMappingSettings.canReplaceRemote(path = PathMappingSettings.norm(path), remotePrefix = PathMappingSettings.norm(remoteRoot))) {
            String left = PathMappingSettings.norm(localRoot);
            String right = path.substring(remotePrefix.length());
            path = left.endsWith("/") || left.endsWith("\\") || right.startsWith("/") || right.startsWith("\\") || StringUtil.isEmpty(left) || StringUtil.isEmpty(right) ? left + right : left + "/" + right;
        }
        return path;
    }

    @Contract(value="null, _ -> true; _, null -> true", pure=true)
    public static boolean isAnyEmpty(@Nullable String localRoot, @Nullable String remoteRoot) {
        return StringUtil.isEmpty(localRoot) || StringUtil.isEmpty(remoteRoot);
    }

    @Nullable
    public static PathMappingSettings readExternal(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        Element settingsElement = element.getChild(PathMappingSettings.class.getSimpleName());
        if (settingsElement == null) {
            return null;
        }
        return XmlSerializer.deserialize(settingsElement, PathMappingSettings.class);
    }

    public static void writeExternal(@Nullable Element element, @Nullable PathMappingSettings mappings) {
        if (element == null || mappings == null || mappings.isEmpty()) {
            return;
        }
        element.addContent(XmlSerializer.serialize(mappings));
    }

    public void addAll(@NotNull PathMappingSettings settings) {
        this.myPathMappings.addAll(settings.getPathMappings());
    }

    public void addAll(@NotNull List<? extends PathMapping> mappings) {
        this.myPathMappings.addAll(mappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMappingSettings settings = (PathMappingSettings)o;
        return this.myPathMappings.equals(settings.myPathMappings);
    }

    public int hashCode() {
        return this.myPathMappings.hashCode();
    }

    private static boolean canReplaceRemote(@NotNull String path, @NotNull String remotePrefix) {
        return (path = PathMappingSettings.norm(path)).startsWith(remotePrefix = PathMappingSettings.norm(remotePrefix)) && (path.length() == remotePrefix.length() || remotePrefix.endsWith("/") || path.substring(remotePrefix.length()).startsWith("/"));
    }

    public String toString() {
        return "PathMappingSettings{myPathMappings=" + this.myPathMappings + "} " + super.toString();
    }

    @Tag(value="mapping")
    public static class PathMapping {
        private String myLocalRoot;
        private String myRemoteRoot;

        public PathMapping() {
        }

        public PathMapping(@Nullable String localRoot, @Nullable String remoteRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @Nullable
        private static String normalize(@Nullable String path) {
            if (path == null) {
                return null;
            }
            return PathMapping.trimSlash(FileUtil.toSystemIndependentName(path));
        }

        @Attribute(value="local-root")
        public String getLocalRoot() {
            return this.myLocalRoot;
        }

        @Attribute(value="remote-root")
        public String getRemoteRoot() {
            return this.myRemoteRoot;
        }

        public int getLocalLen() {
            return this.myLocalRoot != null ? this.myLocalRoot.length() : -1;
        }

        public int getRemoteLen() {
            return this.myRemoteRoot != null ? this.myRemoteRoot.length() : -1;
        }

        public void setLocalRoot(@Nullable String localRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
        }

        public void setRemoteRoot(@Nullable String remoteRoot) {
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @NotNull
        public String mapToLocal(@NotNull String path) {
            return PathMappingSettings.mapToLocal(path, this.myRemoteRoot, this.myLocalRoot);
        }

        public boolean canReplaceLocal(@NotNull String path) {
            if (this.isEmpty()) {
                return false;
            }
            String localPrefix = PathMappingSettings.normLocal(this.myLocalRoot);
            if (localPrefix.isEmpty()) {
                return false;
            }
            String localPath = PathMappingSettings.normLocal(path);
            int prefixLength = localPrefix.length();
            return localPath.startsWith(localPrefix) && (localPath.length() == prefixLength || localPath.charAt(prefixLength) == '/');
        }

        public String mapToRemote(@NotNull String path) {
            if (this.isEmpty()) {
                return path;
            }
            if (this.canReplaceLocal(path)) {
                return PathMappingSettings.norm(this.myRemoteRoot) + PathMappingSettings.norm(path).substring(PathMappingSettings.normLocal(this.myLocalRoot).length());
            }
            return path;
        }

        private boolean isEmpty() {
            return PathMappingSettings.isAnyEmpty(this.myLocalRoot, this.myRemoteRoot);
        }

        private static String trimSlash(@NotNull String s) {
            if (s.equals("/")) {
                return s;
            }
            return StringUtil.trimEnd(s, "/");
        }

        public boolean canReplaceRemote(@NotNull String path) {
            if (this.isEmpty()) {
                return false;
            }
            return PathMappingSettings.canReplaceRemote(path, this.myRemoteRoot);
        }

        public PathMapping clone() {
            return new PathMapping(this.myLocalRoot, this.myRemoteRoot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMapping mapping = (PathMapping)o;
            if (!Objects.equals(this.myLocalRoot, mapping.myLocalRoot)) {
                return false;
            }
            return Objects.equals(this.myRemoteRoot, mapping.myRemoteRoot);
        }

        public String toString() {
            return "{'" + this.myLocalRoot + "' <=> '" + this.myRemoteRoot + "'}";
        }

        public int hashCode() {
            int result = this.myLocalRoot != null ? this.myLocalRoot.hashCode() : 0;
            result = 31 * result + (this.myRemoteRoot != null ? this.myRemoteRoot.hashCode() : 0);
            return result;
        }
    }

    public static class BestMappingSelector {
        private int myBestWeight = -1;
        private PathMapping myBest = null;

        public void consider(PathMapping mapping, int weight) {
            if (weight > this.myBestWeight) {
                this.myBestWeight = weight;
                this.myBest = mapping;
            }
        }

        @Nullable
        public PathMapping get() {
            return this.myBest;
        }
    }
}

