/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotNullizer {
    private final Object myNull;

    @Contract(pure=true)
    public NotNullizer(@NotNull String name) {
        this.myNull = ObjectUtils.sentinel(name);
    }

    @Contract(pure=true)
    @NotNull
    private <T> T fakeNull() {
        return (T)this.myNull;
    }

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public <T> T notNullize(@Nullable T value) {
        if (value == null) {
            return this.fakeNull();
        }
        return value;
    }

    @Contract(pure=true)
    @Nullable
    public <T> T nullize(@NotNull T value) {
        return value == this.myNull ? null : (T)value;
    }
}

