/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ModalityUiUtil {
    public static void invokeLaterIfNeeded(@NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, modalityState);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull Runnable runnable) {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, modalityState, expired);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        ModalityUiUtil.invokeLaterIfNeeded(modalityState, runnable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        ModalityUiUtil.invokeLaterIfNeeded(modalityState, expired, runnable);
    }
}

