/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;

public final class MemoryDumpHelper {
    private static final String HOT_SPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Object ourMXBean;
    private static final Method ourDumpHeap;

    public static boolean memoryDumpAvailable() {
        try {
            return ourMXBean != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public static synchronized void captureMemoryDump(@NotNull String dumpPath) throws Exception {
        ourDumpHeap.invoke(ourMXBean, dumpPath, true);
    }

    public static void captureMemoryDumpZipped(@NotNull String zipPath) throws Exception {
        MemoryDumpHelper.captureMemoryDumpZipped(Paths.get(zipPath, new String[0]));
    }

    public static synchronized void captureMemoryDumpZipped(@NotNull Path zipFile) throws Exception {
        File tempFile = new File(FileUtilRt.getTempDirectory(), "heapDump." + UUID.randomUUID() + ".hprof");
        try {
            MemoryDumpHelper.captureMemoryDump(tempFile.getPath());
            ZipUtil.compressFile(tempFile, zipFile.toFile());
        }
        finally {
            FileUtil.delete(tempFile);
        }
    }

    static {
        Method dumpHeap;
        Object mxBean;
        try {
            Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            mxBean = AccessController.doPrivileged(() -> {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> s = server.queryNames(new ObjectName(HOT_SPOT_BEAN_NAME), null);
                Iterator<ObjectName> itr = s.iterator();
                if (itr.hasNext()) {
                    ObjectName name = itr.next();
                    return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                }
                return null;
            });
            dumpHeap = mxBean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (Throwable t) {
            Logger.getInstance(MemoryDumpHelper.class).info(t.getMessage());
            mxBean = null;
            dumpHeap = null;
        }
        ourMXBean = mxBean;
        ourDumpHeap = dumpHeap;
    }
}

