/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class LocaleSensitiveApplicationCacheService
implements Disposable {
    private final ClearableLazyValue<Map<Class<?>, Object>> myMapProvider = ClearableLazyValue.create(() -> CollectionFactory.createConcurrentWeakMap());

    public LocaleSensitiveApplicationCacheService() {
        if (DynamicBundle.LanguageBundleEP.EP_NAME.getPoint().isDynamic()) {
            DynamicBundle.LanguageBundleEP.EP_NAME.addExtensionPointListener(new ExtensionPointListener<DynamicBundle.LanguageBundleEP>(){

                @Override
                public void extensionAdded(@NotNull DynamicBundle.LanguageBundleEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                    LocaleSensitiveApplicationCacheService.this.myMapProvider.drop();
                }

                @Override
                public void extensionRemoved(@NotNull DynamicBundle.LanguageBundleEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                    LocaleSensitiveApplicationCacheService.this.myMapProvider.drop();
                }
            }, this);
        }
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public <Data> Data getData(@NotNull Class<Data> clazz, @NotNull Supplier<Data> valueComputation) {
        return (Data)this.myMapProvider.getValue().computeIfAbsent(clazz, it -> valueComputation.get());
    }

    @NotNull
    public static LocaleSensitiveApplicationCacheService getInstance() {
        return ApplicationManager.getApplication().getService(LocaleSensitiveApplicationCacheService.class);
    }
}

