/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class InstanceofQuery<S, T>
extends AbstractQuery<T> {
    private final Class<? extends T>[] myClasses;
    private final Query<S> myDelegate;

    public InstanceofQuery(Query<S> delegate, Class<? extends T> ... aClasses) {
        this.myClasses = aClasses;
        this.myDelegate = delegate;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        return InstanceofQuery.delegateProcessResults(this.myDelegate, new MyProcessor(consumer));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.myDelegate.forEachAsync(new MyProcessor(consumer));
    }

    private class MyProcessor
    implements Processor<S> {
        private final Processor<? super T> myConsumer;

        MyProcessor(Processor<? super T> consumer) {
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(S o) {
            for (Class aClass : InstanceofQuery.this.myClasses) {
                if (!aClass.isInstance(o)) continue;
                return this.myConsumer.process(o);
            }
            return true;
        }
    }
}

