/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ForcefulReparseModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FileContentUtilCore {
    public static final String FORCE_RELOAD_REQUESTOR = "FileContentUtilCore.saveOrReload";

    public static void reparseFiles(VirtualFile ... files2) {
        FileContentUtilCore.reparseFiles(Arrays.asList(files2));
    }

    public static void reparseFiles(@NotNull Collection<? extends VirtualFile> files2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            HashSet<VFilePropertyChangeEvent> events = new HashSet<VFilePropertyChangeEvent>();
            for (VirtualFile file2 : files2) {
                if (file2 == null || file2.isDirectory() || !file2.isValid()) continue;
                events.add(new VFilePropertyChangeEvent(FORCE_RELOAD_REQUESTOR, file2, "name", file2.getName(), file2.getName(), false));
            }
            BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List eventList = Collections.unmodifiableList(new ArrayList(events));
            publisher.before(eventList);
            publisher.after(eventList);
            ForcefulReparseModificationTracker.increment();
        });
    }
}

