/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance(ExecutorsQuery.class);
    private final List<? extends QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<? extends QueryExecutor<Result, Parameter>> executors) {
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super Result> consumer) {
        for (QueryExecutor<? super Result, Parameter> queryExecutor : this.myExecutors) {
            try {
                ProgressManager.checkCanceled();
                if (queryExecutor.execute(this.myParameters, consumer)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }
}

