/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ReadEnv;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EnvReader
extends EnvironmentUtil.ShellEnvReader {
    public EnvReader() {
    }

    public EnvReader(long timeoutMillis) {
        super(timeoutMillis);
    }

    @NotNull
    public Map<String, String> readBatEnv(@Nullable Path batchFile, List<String> args2) throws IOException {
        return (Map)this.readBatOutputAndEnv((Path)batchFile, args2).second;
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2) throws IOException {
        return this.readBatOutputAndEnv(batchFile, args2, "cmd.exe");
    }

    @NotNull
    public final Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2, @NotNull String cmdExePath) throws IOException {
        return this.readBatOutputAndEnv(batchFile, args2, cmdExePath, it -> {});
    }

    @NotNull
    public Pair<String, Map<String, String>> readBatOutputAndEnv(@Nullable Path batchFile, @Nullable List<@NotNull String> args2, @NotNull String cmdExePath, @NotNull @NotNull Consumer<@NotNull Map<String, String>> scriptEnvironmentProcessor) throws IOException {
        if (batchFile != null && !Files.exists(batchFile, new LinkOption[0])) {
            throw new NoSuchFileException(batchFile.toString());
        }
        Path envDataFile = Files.createTempFile("intellij-cmd-env-data.", ".tmp", new FileAttribute[0]);
        ArrayList<String> callArgs = new ArrayList<String>();
        if (batchFile != null) {
            callArgs.add("call");
            callArgs.add(batchFile.toString());
            if (args2 != null) {
                callArgs.addAll(args2);
            }
            callArgs.add("1>&2");
            callArgs.add("&&");
        }
        callArgs.add((System.getProperty("java.home") + "/bin/java").replace('/', File.separatorChar));
        callArgs.add("-cp");
        callArgs.add(PathManager.getJarPathForClass(ReadEnv.class));
        callArgs.add(ReadEnv.class.getCanonicalName());
        callArgs.add(">");
        callArgs.add(envDataFile.toString());
        callArgs.add("||");
        callArgs.add("exit");
        callArgs.add("/B");
        callArgs.add("%ERRORLEVEL%");
        ArrayList<@NonNls String> cl = new ArrayList<String>();
        cl.add(cmdExePath);
        cl.add("/c");
        cl.add(EnvReader.prepareCallArgs(callArgs));
        Map.Entry<String, Map<String, String>> entry = this.runProcessAndReadOutputAndEnvs(cl, batchFile != null ? batchFile.getParent() : null, scriptEnvironmentProcessor, envDataFile);
        return new Pair((Object)entry.getKey(), entry.getValue());
    }

    @NotNull
    private static String prepareCallArgs(@NotNull List<String> callArgs) {
        List<String> preparedCallArgs = CommandLineUtil.toCommandLine(callArgs);
        String firstArg = preparedCallArgs.remove(0);
        preparedCallArgs.add(0, CommandLineUtil.escapeParameterOnWindows(firstArg, false));
        return "\"" + String.join((CharSequence)" ", preparedCallArgs) + "\"";
    }
}

