/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposeAwareRunnable<T extends Runnable>
extends WeakReference<Object>
implements Runnable {
    protected final T myDelegate;

    private DisposeAwareRunnable(@NotNull T delegate, @NotNull Object disposable) {
        super(disposable);
        this.myDelegate = delegate;
        assert (disposable instanceof PsiElement || disposable instanceof ComponentManager) : "Unknown type of " + disposable;
    }

    @NotNull
    public static Runnable create(@NotNull Runnable delegate, @Nullable PsiElement disposable) {
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    @NotNull
    public static Runnable create(@NotNull Runnable delegate, @Nullable Project disposable) {
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    @NotNull
    public static Runnable create(@NotNull Runnable delegate, @Nullable Module disposable) {
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    @NotNull
    private static Runnable create(@NotNull Runnable delegate, @Nullable Object disposable) {
        if (disposable == null) {
            return delegate;
        }
        if (delegate instanceof DumbAware) {
            return DumbAwareRunnable.create((Runnable)((Object)((DumbAware)((Object)delegate))), disposable);
        }
        if (delegate instanceof PossiblyDumbAware) {
            return PossiblyDumbAwareRunnable.create((Runnable)((Object)((PossiblyDumbAware)((Object)delegate))), disposable);
        }
        return new DisposeAwareRunnable<Runnable>(delegate, disposable);
    }

    @Override
    public void run() {
        Object res = this.get();
        if (res == null) {
            return;
        }
        if (res instanceof PsiElement ? !((PsiElement)res).isValid() : res instanceof ComponentManager && ((ComponentManager)res).isDisposed()) {
            return;
        }
        this.myDelegate.run();
    }

    /* synthetic */ DisposeAwareRunnable(Runnable x0, Object x1, 1 x2) {
        this(x0, x1);
    }

    private static final class PossiblyDumbAwareRunnable<T extends Runnable & PossiblyDumbAware>
    extends DisposeAwareRunnable<T>
    implements PossiblyDumbAware {
        @NotNull
        private static <T extends Runnable & PossiblyDumbAware> PossiblyDumbAwareRunnable<T> create(@NotNull T delegate, Object o) {
            return new PossiblyDumbAwareRunnable<T>(delegate, o);
        }

        private PossiblyDumbAwareRunnable(T delegate, Object disposable) {
            super((Runnable)delegate, disposable, null);
        }

        @Override
        public boolean isDumbAware() {
            return ((PossiblyDumbAware)((Object)this.myDelegate)).isDumbAware();
        }
    }

    private static final class DumbAwareRunnable<T extends Runnable & DumbAware>
    extends DisposeAwareRunnable<T>
    implements DumbAware {
        @NotNull
        private static <T extends Runnable & DumbAware> DumbAwareRunnable<T> create(@NotNull T delegate, Object o) {
            return new DumbAwareRunnable<T>(delegate, o);
        }

        private DumbAwareRunnable(@NotNull T delegate, Object disposable) {
            super((Runnable)delegate, disposable, null);
        }
    }
}

