/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultBundleService {
    private static final DefaultBundleService INSTANCE = new DefaultBundleService();
    private static final ThreadLocal<Boolean> ourDefaultBundle = ThreadLocal.withInitial(() -> false);

    @NotNull
    public static DefaultBundleService getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T compute(@NotNull Supplier<? extends T> computable) {
        boolean isDefault = DefaultBundleService.isDefaultBundle();
        if (!isDefault) {
            ourDefaultBundle.set(true);
        }
        try {
            T t = computable.get();
            return t;
        }
        finally {
            if (!isDefault) {
                ourDefaultBundle.set(false);
            }
        }
    }

    public static boolean isDefaultBundle() {
        return ourDefaultBundle.get();
    }
}

