/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingException;
import com.intellij.util.ThrowableRunnable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AstLoadingFilter {
    private static final Logger LOG = Logger.getInstance(AstLoadingFilter.class);
    private static final ThreadLocal<Supplier<String>> myDisallowedInfo = new ThreadLocal();
    private static final ThreadLocal<Set<VirtualFile>> myForcedAllowedFiles = ThreadLocal.withInitial(() -> new HashSet());

    private AstLoadingFilter() {
    }

    public static void assertTreeLoadingAllowed(@NotNull VirtualFile file2) {
        if (file2 instanceof VirtualFileWindow || !Registry.is("ast.loading.filter", false)) {
            return;
        }
        Supplier<String> disallowedInfo = myDisallowedInfo.get();
        if (disallowedInfo != null && !myForcedAllowedFiles.get().contains(file2)) {
            AstLoadingException throwable = new AstLoadingException();
            LOG.error("Tree access disabled", (Throwable)throwable, new Attachment("debugInfo", AstLoadingFilter.buildDebugInfo(file2, disallowedInfo)));
        }
    }

    @NotNull
    private static String buildDebugInfo(@NotNull VirtualFile file2, @NotNull Supplier<String> disabledInfo) {
        @NonNls StringBuilder debugInfo = new StringBuilder();
        debugInfo.append("Accessed file path: ").append(file2.getPath());
        String additionalInfo = disabledInfo.get();
        if (additionalInfo != null) {
            debugInfo.append('\n').append("Additional info: \n").append(additionalInfo);
        }
        return debugInfo.toString();
    }

    public static <E extends Throwable> void disallowTreeLoading(@NotNull ThrowableRunnable<E> runnable) throws E {
        AstLoadingFilter.disallowTreeLoading(AstLoadingFilter.toComputable(runnable));
    }

    public static <E extends Throwable> void disallowTreeLoading(@NotNull ThrowableRunnable<E> runnable, @NotNull Supplier<String> debugInfo) throws E {
        AstLoadingFilter.disallowTreeLoading(AstLoadingFilter.toComputable(runnable), debugInfo);
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable) throws E {
        return AstLoadingFilter.disallowTreeLoading(computable, () -> null);
    }

    public static <T, E extends Throwable> T disallowTreeLoading(@NotNull ThrowableComputable<? extends T, E> computable, @NotNull Supplier<String> debugInfo) throws E {
        if (myDisallowedInfo.get() != null) {
            return (T)computable.compute();
        }
        try {
            myDisallowedInfo.set(debugInfo);
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            myDisallowedInfo.set(null);
        }
    }

    public static <E extends Throwable> void forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableRunnable<E> runnable) throws E {
        AstLoadingFilter.forceAllowTreeLoading(psiFile, AstLoadingFilter.toComputable(runnable));
    }

    public static <E extends Throwable> void forceAllowTreeLoading(@NotNull VirtualFile virtualFile, @NotNull ThrowableRunnable<E> runnable) throws E {
        AstLoadingFilter.forceAllowTreeLoading(virtualFile, AstLoadingFilter.toComputable(runnable));
    }

    public static <T, E extends Throwable> T forceAllowTreeLoading(@Nullable PsiFile psiFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        VirtualFile virtualFile = psiFile == null ? null : psiFile.getVirtualFile();
        return (T)(virtualFile == null ? computable.compute() : AstLoadingFilter.forceAllowTreeLoading(virtualFile, computable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T forceAllowTreeLoading(@NotNull VirtualFile virtualFile, @NotNull ThrowableComputable<? extends T, E> computable) throws E {
        Set<VirtualFile> enabledFiles = myForcedAllowedFiles.get();
        if (enabledFiles.add(virtualFile)) {
            try {
                Object object = computable.compute();
                return (T)object;
            }
            finally {
                enabledFiles.remove(virtualFile);
            }
        }
        return (T)computable.compute();
    }

    private static <E extends Throwable> ThrowableComputable<?, E> toComputable(ThrowableRunnable<? extends E> runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

