/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DummyIconManager
implements IconManager {
    static final IconManager INSTANCE = new DummyIconManager();

    private DummyIconManager() {
    }

    @Override
    @NotNull
    public Icon getStubIcon() {
        return DummyIcon.INSTANCE;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        return new DummyIcon(path);
    }

    @Override
    @NotNull
    public Icon loadRasterizedIcon(@NotNull String path, @NotNull ClassLoader classLoader, int cacheKey, int flags) {
        return new DummyIcon(path);
    }

    @Override
    @NotNull
    public RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        Icon[] icons = new Icon[2];
        icons[0] = icon;
        return new DummyRowIcon(icons);
    }

    @Override
    public void registerIconLayer(int flagMask, @NotNull Icon icon) {
    }

    @Override
    @NotNull
    public Icon tooltipOnlyIfComposite(@NotNull Icon icon) {
        return icon;
    }

    @Override
    @NotNull
    public <T> Icon createDeferredIcon(@Nullable Icon base, T param, @NotNull Function<? super T, ? extends Icon> iconProducer) {
        return base;
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new DummyRowIcon(iconCount);
    }

    @Override
    @NotNull
    public Icon createLayered(Icon ... icons) {
        return new DummyRowIcon(icons);
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        return new DummyRowIcon(icons);
    }

    private static final class DummyRowIcon
    extends DummyIcon
    implements RowIcon {
        private Icon[] icons;

        DummyRowIcon(int iconCount) {
            super("<DummyRowIcon>");
            this.icons = new Icon[iconCount];
        }

        DummyRowIcon(Icon[] icons) {
            super("<DummyRowIcon>");
            this.icons = icons;
        }

        @Override
        public int getIconCount() {
            return this.icons == null ? 0 : this.icons.length;
        }

        @Override
        public Icon getIcon(int index) {
            return this.icons[index];
        }

        @Override
        public void setIcon(Icon icon, int i) {
            if (this.icons == null) {
                this.icons = new Icon[4];
            }
            this.icons[i] = icon;
        }

        @Override
        @NotNull
        public Icon getDarkIcon(boolean isDark) {
            return this;
        }

        @Override
        public Icon @NotNull [] getAllIcons() {
            ArrayList<Icon> list = new ArrayList<Icon>();
            for (Icon element : this.icons) {
                if (element == null) continue;
                list.add(element);
            }
            return list.toArray(new Icon[0]);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof DummyRowIcon && Arrays.equals(this.icons, ((DummyRowIcon)o).icons);
        }

        @Override
        public int hashCode() {
            return this.icons.length > 0 ? this.icons[0].hashCode() : 0;
        }

        @Override
        public String toString() {
            return "Row icon. myIcons=" + Arrays.asList(this.icons);
        }
    }

    private static class DummyIcon
    implements ScalableIcon {
        static final DummyIcon INSTANCE = new DummyIcon("<DummyIcon>");
        private final String path;

        private DummyIcon(@NotNull String path) {
            this.path = path;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof DummyIcon && ((DummyIcon)obj).path == this.path;
        }

        public String toString() {
            return this.path;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        @NotNull
        public Icon scale(float scaleFactor) {
            return this;
        }
    }
}

