/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.TestModeFlagListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TestModeFlags {
    private static final Map<String, Object> ourFlags = new HashMap<String, Object>();
    private static final List<TestModeFlagListener> ourListeners = new CopyOnWriteArrayList<TestModeFlagListener>();

    @TestOnly
    public static <T> T set(@NotNull Key<T> flag, @Nullable T value) {
        Object oldValue = ourFlags.get(flag.toString());
        ourFlags.put(flag.toString(), value);
        for (TestModeFlagListener listener : ourListeners) {
            listener.testModeFlagChanged(flag, value);
        }
        return (T)oldValue;
    }

    @TestOnly
    public static void reset(@NotNull Key<?> flag) {
        TestModeFlags.set(flag, null);
    }

    @TestOnly
    public static <T> void set(@NotNull Key<T> flag, T value, @NotNull Disposable parentDisposable) {
        Object oldValue = TestModeFlags.get(flag);
        TestModeFlags.set(flag, value);
        Disposer.register(parentDisposable, () -> TestModeFlags.set(flag, oldValue));
    }

    public static <T> T get(@NotNull Key<T> flag) {
        return (T)ourFlags.get(flag.toString());
    }

    public static boolean is(@NotNull Key<Boolean> flag) {
        return TestModeFlags.get(flag) == Boolean.TRUE;
    }

    public static void addListener(@NotNull TestModeFlagListener listener) {
        ourListeners.add(listener);
    }
}

