/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class BinaryLightVirtualFile
extends LightVirtualFileBase {
    private byte[] myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;

    public BinaryLightVirtualFile(String name) {
        this(name, ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public BinaryLightVirtualFile(String name, byte @NotNull [] content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte @NotNull [] content) {
        this(name, fileType, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte @NotNull [] content, long modificationStamp) {
        super(name, fileType, modificationStamp);
        this.setContent(content);
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.myContent, this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                BinaryLightVirtualFile.this.setModificationStamp(newModificationStamp);
                BinaryLightVirtualFile.this.setContent(this.toByteArray());
            }
        }, this);
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        return this.myContent;
    }

    private void setContent(byte @NotNull [] content) {
        this.myContent = content;
    }

    public byte @NotNull [] getContent() {
        return this.myContent;
    }

    @Override
    public String toString() {
        return "BinaryLightVirtualFile: " + this.getPresentableUrl();
    }
}

