/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class LazyExtensionInstance<T> {
    private volatile T instance;

    protected LazyExtensionInstance() {
    }

    @TestOnly
    protected LazyExtensionInstance(@NotNull T instance) {
        this.instance = instance;
    }

    @Nullable
    protected abstract String getImplementationClassName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final T getInstance(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor) {
        T result = this.instance;
        if (result != null) {
            return result;
        }
        LazyExtensionInstance lazyExtensionInstance = this;
        synchronized (lazyExtensionInstance) {
            result = this.instance;
            if (result != null) {
                return result;
            }
            this.instance = result = this.createInstance(componentManager, pluginDescriptor);
        }
        return result;
    }

    @NotNull
    public T createInstance(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor) {
        String className = this.getImplementationClassName();
        if (className == null) {
            throw new PluginException("implementation class is not specified", pluginDescriptor.getPluginId());
        }
        return componentManager.instantiateClass(className, pluginDescriptor);
    }
}

