/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.serialization.FieldAccessor;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyAccessor;
import com.intellij.util.BitUtil;
import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PropertyCollector {
    private final ClassValue<List<MutableAccessor>> classToOwnFields;
    public static final byte COLLECT_ACCESSORS = 1;
    public static final byte COLLECT_PRIVATE_FIELDS = 2;
    public static final byte COLLECT_FINAL_FIELDS = 4;
    private final Configuration configuration;

    public PropertyCollector(@NotNull Configuration configuration) {
        this.configuration = configuration;
        this.classToOwnFields = new PropertyCollectorListClassValue(configuration);
    }

    public PropertyCollector(byte flags) {
        this(new Configuration(BitUtil.isSet(flags, (byte)1), BitUtil.isSet(flags, (byte)2), BitUtil.isSet(flags, (byte)4)));
    }

    @NotNull
    public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
        return PropertyCollector.doCollect(aClass, this.configuration, this.classToOwnFields);
    }

    @NotNull
    public static List<MutableAccessor> doCollect(@NotNull Class<?> aClass, @NotNull Configuration configuration, @Nullable ClassValue<List<MutableAccessor>> classToOwnFields) {
        ArrayList<MutableAccessor> accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = !configuration.collectAccessors || aClass == Rectangle.class ? Collections.emptyMap() : PropertyCollector.collectPropertyAccessors(aClass, accessors, configuration);
        int propertyAccessorCount = accessors.size();
        Class<?> currentClass = aClass;
        do {
            accessors.addAll(classToOwnFields == null ? PropertyCollector.doCollectOwnFields(currentClass, configuration) : (Collection)classToOwnFields.get(currentClass));
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass != Object.class && currentClass != AtomicReference.class && !configuration.isAnnotatedAsTransient(currentClass));
        block1: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = ((MutableAccessor)accessors.get(j)).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!((MutableAccessor)accessors.get(i)).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block1;
            }
        }
        return accessors;
    }

    @NotNull
    private static Map<String, Pair<Method, Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors, @NotNull Configuration configuration) {
        TreeMap<String, Pair<Method, Method>> candidates = new TreeMap<String, Pair<Method, Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = PropertyCollector.getPropertyData(method.getName())) == null || method.getParameterCount() != (propertyData.isSetter ? 1 : 0) || propertyData.name.equals("class")) continue;
            Pair candidate = (Pair)candidates.get(propertyData.name);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = new Couple((Object)(propertyData.isSetter ? (Method)candidate.first : method), (Object)(propertyData.isSetter ? method : (Method)candidate.second));
            candidates.put(propertyData.name, (Pair<Method, Method>)candidate);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry candidate = iterator.next();
            Pair methods = (Pair)candidate.getValue();
            Method getter = (Method)methods.first;
            Method setter = (Method)methods.second;
            if (PropertyCollector.isAcceptableProperty(getter, setter, configuration)) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), getter.getReturnType(), getter, setter));
                continue;
            }
            iterator.remove();
        }
        return candidates;
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(PropertyCollector.decapitalize(part), isSetter);
    }

    @NotNull
    private static String decapitalize(@NotNull String name) {
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(name.charAt(0));
        return new String(chars);
    }

    private static boolean isAcceptableProperty(@Nullable Method getter, @Nullable Method setter, @NotNull Configuration configuration) {
        if (getter == null || configuration.isAnnotatedAsTransient(getter)) {
            return false;
        }
        if (getter.getDeclaringClass() == AtomicReference.class) {
            return false;
        }
        if (setter == null) {
            return (Collection.class.isAssignableFrom(getter.getReturnType()) || Map.class.isAssignableFrom(getter.getReturnType())) && configuration.hasStoreAnnotations(getter);
        }
        return !configuration.isAnnotatedAsTransient(setter) && getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    @NotNull
    private static List<MutableAccessor> doCollectOwnFields(@NotNull Class<?> type, @NotNull Configuration configuration) {
        ArrayList<FieldAccessor> result = null;
        for (Field field : type.getDeclaredFields()) {
            Class<?> fieldType;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !configuration.hasStoreAnnotations(field) && (!configuration.collectPrivateFields && !Modifier.isPublic(modifiers) || !configuration.collectFinalFields && Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(fieldType = field.getType()) && !Map.class.isAssignableFrom(fieldType) || configuration.isAnnotatedAsTransient(field))) continue;
            if (result == null) {
                result = new ArrayList<FieldAccessor>();
            }
            result.add(new FieldAccessor(field));
        }
        return result == null ? Collections.emptyList() : result;
    }

    private static final class PropertyCollectorListClassValue
    extends ClassValue<List<MutableAccessor>> {
        @NotNull
        private final Configuration configuration;

        private PropertyCollectorListClassValue(@NotNull Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        protected List<MutableAccessor> computeValue(Class<?> type) {
            return PropertyCollector.doCollectOwnFields(type, this.configuration);
        }
    }

    public static class Configuration {
        private final boolean collectAccessors;
        private final boolean collectPrivateFields;
        private final boolean collectFinalFields;

        public Configuration(boolean collectAccessors, boolean collectPrivateFields, boolean collectFinalFields) {
            this.collectAccessors = collectAccessors;
            this.collectPrivateFields = collectPrivateFields;
            this.collectFinalFields = collectFinalFields;
        }

        public boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
            return false;
        }

        public boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
            return false;
        }
    }

    private static final class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

