/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileSetEx;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.impl.IntersectionFileEnumeration;
import com.intellij.psi.search.impl.UnionFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @ApiStatus.NonExtendable
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file2) {
        return this.contains(file2);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return Collections.emptySet();
    }

    @ApiStatus.Experimental
    @NotNull
    public Collection<ModelBranch> getModelBranchesAffectingScope() {
        return Collections.emptySet();
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == this) {
            return this;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            return scope;
        }
        return new IntersectionScope(this, scope);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 instanceof LocalSearchScope) {
            return this.intersectWith((LocalSearchScope)scope2);
        }
        return this.intersectWith((GlobalSearchScope)scope2);
    }

    @NotNull
    @Contract(pure=true)
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result.add(element2);
        }
        return result.isEmpty() ? LocalSearchScope.EMPTY : new LocalSearchScope(result.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope instanceof GlobalSearchScope) {
            return this.uniteWith((GlobalSearchScope)scope);
        }
        return this.union((LocalSearchScope)scope);
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements = scope.getScope();
        if (localScopeElements.length == 0) {
            return this;
        }
        return new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                return GlobalSearchScope.this.contains(file2) || scope.isInScope(file2);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                return GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
            }

            @Override
            @NotNull
            public Collection<ModelBranch> getModelBranchesAffectingScope() {
                return GlobalSearchScope.this.getModelBranchesAffectingScope();
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        return UnionScope.create(new GlobalSearchScope[]{this, scope});
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            return scopes.iterator().next();
        }
        return UnionScope.create(scopes.toArray(EMPTY_ARRAY));
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(GlobalSearchScope @NotNull [] scopes) {
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            return scopes[0];
        }
        return UnionScope.create(scopes);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope allScope(@NotNull Project project) {
        return ProjectScope.getAllScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        return ProjectScope.getProjectScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        return ProjectScope.getEverythingScope(project);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        return new NotScope(scope);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        return module.getModuleScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        return module.getModuleWithLibrariesScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        return module.getModuleWithDependenciesScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        return module.getModuleRuntimeScope(includeTests);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        return module.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        return module.getModuleWithDependentsScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        return module.getModuleTestsWithDependentsScope();
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile(), null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile) {
        return GlobalSearchScope.fileScope(project, virtualFile, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
        return new FileScope(project, virtualFile, displayName);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        return GlobalSearchScope.filesScope(project, files2, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files2) {
        return new LazyFilesScope(project, files2);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (files2.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new FilesScope(project, files2, false);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2) {
        if (files2.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new FilesScope(project, files2, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files2, final @Nullable @Nls String displayName) {
        if (files2.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return files2.size() == 1 ? GlobalSearchScope.fileScope(project, files2.iterator().next(), displayName) : new FilesScope(project, files2){

            @Override
            @NotNull
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == EMPTY_SCOPE) {
            return EMPTY_SCOPE;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    private static class LazyFilesScope
    extends AbstractFilesScope {
        private volatile VirtualFileSet myFiles;
        @NotNull
        private Supplier<? extends Collection<? extends VirtualFile>> myFilesSupplier;

        private LazyFilesScope(@Nullable Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files2) {
            super(project, null);
            this.myFilesSupplier = files2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public VirtualFileSet getFiles() {
            if (this.myFiles == null) {
                LazyFilesScope lazyFilesScope = this;
                synchronized (lazyFilesScope) {
                    if (this.myFiles == null) {
                        VirtualFileSet fileSet = VfsUtilCore.createCompactVirtualFileSet(this.myFilesSupplier.get());
                        fileSet.freeze();
                        this.myFilesSupplier = null;
                        this.myFiles = fileSet;
                    }
                }
            }
            return this.myFiles;
        }

        public String toString() {
            return "Files: [" + (this.myFiles == null ? "(not loaded yet)" : StringUtil.join(this.myFiles, ", ")) + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }
    }

    public static class FilesScope
    extends AbstractFilesScope {
        private final VirtualFileSet myFiles;

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2) {
            this(project, files2, null);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files2, @Nullable Boolean hasFilesOutOfProjectRoots) {
            super(project, hasFilesOutOfProjectRoots);
            this.myFiles = VfsUtilCore.createCompactVirtualFileSet(files2);
            this.myFiles.freeze();
        }

        @Override
        @NotNull
        public VirtualFileSet getFiles() {
            return this.myFiles;
        }

        public String toString() {
            return "Files: [" + StringUtil.join(this.myFiles, ", ") + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }
    }

    private static abstract class AbstractFilesScope
    extends GlobalSearchScope
    implements VirtualFileEnumeration {
        volatile Boolean myHasFilesOutOfProjectRoots;

        AbstractFilesScope(@Nullable Project project, @Nullable Boolean hasFilesOutOfProjectRoots) {
            super(project);
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @NotNull
        abstract VirtualFileSet getFiles();

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return this.getFiles().contains(file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof AbstractFilesScope && this.getFiles().equals(((AbstractFilesScope)o).getFiles());
        }

        @Override
        public int calcHashCode() {
            return this.getFiles().hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result = this.myHasFilesOutOfProjectRoots;
            if (result == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result = Boolean.valueOf(project != null && !project.isDefault() && ContainerUtil.find(this.getFiles(), file2 -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file2) != null) == null);
            }
            return result;
        }

        @Override
        public boolean contains(int fileId) {
            return ((VirtualFileSetEx)this.getFiles()).containsId(fileId);
        }

        @Override
        public int @NotNull [] asArray() {
            return ((VirtualFileSetEx)this.getFiles()).onlyInternalFileIds();
        }
    }

    private static final class FileScope
    extends GlobalSearchScope
    implements VirtualFileEnumeration {
        private final VirtualFile myVirtualFile;
        @Nullable
        @Nls
        private final String myDisplayName;
        private final Module myModule;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
            super(project);
            this.myVirtualFile = virtualFile;
            this.myDisplayName = displayName;
            FileIndexFacade facade = project.isDefault() ? null : FileIndexFacade.getInstance(project);
            this.myModule = virtualFile == null || facade == null ? null : facade.getModuleForFile(virtualFile);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return Comparing.equal((Object)this.myVirtualFile, (Object)file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File: " + this.myVirtualFile;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            return this.myVirtualFile == null ? Collections.emptyList() : ContainerUtil.createMaybeSingletonList(ModelBranch.getFileBranch(this.myVirtualFile));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FileScope files2 = (FileScope)o;
            return Objects.equals(this.myVirtualFile, files2.myVirtualFile) && Objects.equals(this.myDisplayName, files2.myDisplayName) && Objects.equals(this.myModule, files2.myModule);
        }

        @Override
        protected int calcHashCode() {
            return Objects.hash(this.myVirtualFile, this.myModule, this.myDisplayName);
        }

        @Override
        public boolean contains(int fileId) {
            return this.myVirtualFile instanceof VirtualFileWithId && ((VirtualFileWithId)((Object)this.myVirtualFile)).getId() == fileId;
        }

        @Override
        public int @NotNull [] asArray() {
            int[] nArray;
            if (this.myVirtualFile instanceof VirtualFileWithId) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = ((VirtualFileWithId)((Object)this.myVirtualFile)).getId();
            } else {
                nArray = ArrayUtil.EMPTY_INT_ARRAY;
            }
            return nArray;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            return this;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            return scope;
        }

        public String toString() {
            return "EMPTY";
        }
    }

    private static final class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, FileType @NotNull [] fileTypes) {
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (!super.contains(file2)) {
                return false;
            }
            for (FileType otherFileType : this.myFileTypes) {
                if (!FileTypeRegistry.getInstance().isFileOfType(file2, otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
                }
            }
            return super.intersectWith(scope);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                }
            }
            return super.uniteWith(scope);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int calcHashCode() {
            int result = super.calcHashCode();
            result = 31 * result + Arrays.hashCode(this.myFileTypes);
            return result;
        }

        @Override
        public String toString() {
            return "Restricted by file types: " + Arrays.asList(this.myFileTypes) + " in (" + this.myBaseScope + ")";
        }

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            return this.myBaseScope instanceof VirtualFileEnumeration ? (VirtualFileEnumeration)((Object)this.myBaseScope) : null;
        }
    }

    private static final class UnionScope
    extends GlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final GlobalSearchScope @NotNull [] myScopes;

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            SmartList<VirtualFileEnumeration> fileEnumerations = new SmartList<VirtualFileEnumeration>();
            for (GlobalSearchScope scope : this.myScopes) {
                VirtualFileEnumeration fileEnumeration = VirtualFileEnumeration.extract(scope);
                if (fileEnumeration == null) {
                    return null;
                }
                fileEnumerations.add(fileEnumeration);
            }
            return new UnionFileEnumeration(fileEnumerations);
        }

        @NotNull
        static GlobalSearchScope create(GlobalSearchScope @NotNull [] scopes) {
            GlobalSearchScope unionScope;
            if (scopes.length == 2 && (unionScope = UnionScope.tryCreateUnionFor2Scopes(scopes)) != null) {
                return unionScope;
            }
            HashSet<GlobalSearchScope> result = new HashSet<GlobalSearchScope>(scopes.length);
            Project project = null;
            for (GlobalSearchScope scope : scopes) {
                if (scope == EMPTY_SCOPE) continue;
                Project scopeProject = scope.getProject();
                if (scopeProject != null) {
                    project = scopeProject;
                }
                if (scope instanceof UnionScope) {
                    ContainerUtil.addAll(result, ((UnionScope)scope).myScopes);
                    continue;
                }
                result.add(scope);
            }
            if (result.isEmpty()) {
                return EMPTY_SCOPE;
            }
            if (result.size() == 1) {
                return (GlobalSearchScope)result.iterator().next();
            }
            return new UnionScope(project, result.toArray(EMPTY_ARRAY));
        }

        @Nullable
        private static GlobalSearchScope tryCreateUnionFor2Scopes(GlobalSearchScope @NotNull [] scopes) {
            assert (scopes.length == 2);
            GlobalSearchScope scope0 = scopes[0];
            GlobalSearchScope scope1 = scopes[1];
            if (scope0 == EMPTY_SCOPE) {
                return scope1;
            }
            if (scope1 == EMPTY_SCOPE) {
                return scope0;
            }
            if (scope0 instanceof UnionScope && scope1 instanceof UnionScope) {
                return null;
            }
            Project project = ObjectUtils.chooseNotNull(scope0.getProject(), scope1.getProject());
            if (scope0 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope0, scope1, project);
            }
            if (scope1 instanceof UnionScope) {
                return UnionScope.unionWithUnionScope(scope1, scope0, project);
            }
            return new UnionScope(project, scopes);
        }

        @NotNull
        private static GlobalSearchScope unionWithUnionScope(GlobalSearchScope scope0, GlobalSearchScope scope1, Project project) {
            GlobalSearchScope[] scopes0 = ((UnionScope)scope0).myScopes;
            if (ArrayUtil.contains(scope1, scopes0)) {
                return scope0;
            }
            return new UnionScope(project, ArrayUtil.append(scopes0, scope1));
        }

        private UnionScope(Project project, GlobalSearchScope @NotNull [] scopes) {
            super(project);
            this.myScopes = scopes;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return CoreBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return ContainerUtil.find(this.myScopes, scope -> scope.contains(file2)) != null;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<UnloadedModuleDescription> result = new LinkedHashSet<UnloadedModuleDescription>();
            for (GlobalSearchScope scope : this.myScopes) {
                result.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            return result;
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            LinkedHashSet<ModelBranch> result = new LinkedHashSet<ModelBranch>();
            for (GlobalSearchScope scope : this.myScopes) {
                result.addAll(scope.getModelBranchesAffectingScope());
            }
            return result;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            int[] result = new int[]{0};
            ContainerUtil.process(this.myScopes, scope -> {
                if (!scope.contains(file1) || !scope.contains(file2)) {
                    return true;
                }
                int cmp = scope.compare(file1, file2);
                if (result[0] == 0) {
                    result[0] = cmp;
                    return true;
                }
                if (cmp == 0) {
                    return true;
                }
                if (result[0] > 0 == cmp > 0) {
                    return true;
                }
                result[0] = 0;
                return false;
            });
            return result[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module) {
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module)) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module, boolean testSources) {
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module, testSources)) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return ContainerUtil.set(this.myScopes).equals(ContainerUtil.set(that.myScopes));
        }

        @Override
        public int calcHashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
                return UnionScope.create(newScopes);
            }
            return super.uniteWith(scope);
        }
    }

    private static final class IntersectionScope
    extends GlobalSearchScope
    implements VirtualFileEnumerationAware {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            return this.containsScope(scope) ? this : new IntersectionScope(this, scope);
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return CoreBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return this.myScope1.contains(file2) && this.myScope2.contains(file2);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if (res1 > 0 == res2 > 0) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
        }

        @Override
        @NotNull
        public Collection<ModelBranch> getModelBranchesAffectingScope() {
            return ContainerUtil.intersection(this.myScope1.getModelBranchesAffectingScope(), this.myScope2.getModelBranchesAffectingScope());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int calcHashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }

        @Override
        @Nullable
        public VirtualFileEnumeration extractFileEnumeration() {
            VirtualFileEnumeration fileEnumeration1 = VirtualFileEnumeration.extract(this.myScope1);
            VirtualFileEnumeration fileEnumeration2 = VirtualFileEnumeration.extract(this.myScope2);
            if (fileEnumeration1 == null) {
                return fileEnumeration2;
            }
            if (fileEnumeration2 == null) {
                return fileEnumeration1;
            }
            return new IntersectionFileEnumeration(Arrays.asList(fileEnumeration1, fileEnumeration2));
        }
    }

    private static final class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            return !this.myBaseScope.contains(file2);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public String toString() {
            return "NOT: (" + this.myBaseScope + ")";
        }
    }
}

