/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiReference {
    public static final PsiReference[] EMPTY_ARRAY = new PsiReference[0];
    public static final ArrayFactory<PsiReference> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiReference[count];

    @NotNull
    public PsiElement getElement();

    @NotNull
    public TextRange getRangeInElement();

    @NotNull
    default public TextRange getAbsoluteRange() {
        return this.getRangeInElement().shiftRight(this.getElement().getTextRange().getStartOffset());
    }

    @Nullable
    public PsiElement resolve();

    @NotNull
    @NlsSafe
    public String getCanonicalText();

    public PsiElement handleElementRename(@NotNull String var1) throws IncorrectOperationException;

    public PsiElement bindToElement(@NotNull PsiElement var1) throws IncorrectOperationException;

    public boolean isReferenceTo(@NotNull PsiElement var1);

    default public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft();
}

