/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class CharPattern
extends ObjectPattern<Character, CharPattern> {
    private static final CharPattern ourJavaIdentifierStartCharacter = StandardPatterns.character().javaIdentifierStart();
    private static final CharPattern ourJavaIdentifierPartCharacter = StandardPatterns.character().javaIdentifierPart();
    private static final CharPattern ourWhitespaceCharacter = StandardPatterns.character().whitespace();
    private static final CharPattern ourLetterOrDigitCharacter = StandardPatterns.character().letterOrDigit();

    protected CharPattern() {
        super(Character.class);
    }

    public CharPattern javaIdentifierPart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierPart"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                return Character.isJavaIdentifierPart(character.charValue());
            }
        });
    }

    public CharPattern javaIdentifierStart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierStart"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                return Character.isJavaIdentifierStart(character.charValue());
            }
        });
    }

    public CharPattern whitespace() {
        return (CharPattern)this.with(new PatternCondition<Character>("whitespace"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                return Character.isWhitespace(character.charValue());
            }
        });
    }

    public CharPattern letterOrDigit() {
        return (CharPattern)this.with(new PatternCondition<Character>("letterOrDigit"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                return Character.isLetterOrDigit(character.charValue());
            }
        });
    }

    public static CharPattern javaIdentifierStartCharacter() {
        return ourJavaIdentifierStartCharacter;
    }

    public static CharPattern javaIdentifierPartCharacter() {
        return ourJavaIdentifierPartCharacter;
    }

    public static CharPattern letterOrDigitCharacter() {
        return ourLetterOrDigitCharacter;
    }

    public static CharPattern whitespaceCharacter() {
        return ourWhitespaceCharacter;
    }
}

