/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        super(requestor, false);
        this.myFile = file2;
        this.myNewParent = newParent;
        this.myOldParent = file2.getParent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        return this.computePath();
    }

    @Override
    @NotNull
    protected String computePath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && Comparing.equal((Object)this.myFile.getParent(), (Object)this.myOldParent) && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myOldParent.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        return result;
    }

    @NotNull
    public String getOldPath() {
        return this.myOldParent.getPath() + "/" + this.myFile.getName();
    }

    @NotNull
    public String getNewPath() {
        return this.myNewParent.getPath() + "/" + this.myFile.getName();
    }
}

