/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WritingAccessProvider {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final ExtensionPointName<WritingAccessProvider> EP_NAME = ExtensionPointName.create("com.intellij.writingAccessProvider");
    public static final ProjectExtensionPointName<WritingAccessProvider> EP = new ProjectExtensionPointName("com.intellij.writingAccessProvider");

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        return this.requestWriting(files2.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getReadOnlyMessage() {
        return CoreBundle.message("editing.read.only.file.hint", new Object[0]);
    }

    @Deprecated
    public Collection<VirtualFile> requestWriting(VirtualFile ... files2) {
        throw new AbstractMethodError("requestWriting(List<VirtualFile>) not implemented");
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        return true;
    }

    public static boolean isPotentiallyWritable(@NotNull VirtualFile file2, @Nullable Project project) {
        return project == null || project.isDefault() || EP.findFirstSafe(project, provider -> !provider.isPotentiallyWritable(file2)) == null;
    }
}

