/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileVisitor<T> {
    private boolean myFollowSymLinks = true;
    private boolean mySkipRoot;
    private int myDepthLimit = -1;
    private int myLevel;
    private Stack<T> myValueStack;
    private T myValue;
    public static final Option NO_FOLLOW_SYMLINKS = new Option();
    public static final Option SKIP_ROOT = new Option();
    public static final Option ONE_LEVEL_DEEP = VirtualFileVisitor.limit(1);
    public static final Result CONTINUE = new Result(false, null);
    public static final Result SKIP_CHILDREN = new Result(true, null);

    protected VirtualFileVisitor(Option ... options) {
        for (Option option : options) {
            if (option == NO_FOLLOW_SYMLINKS) {
                this.myFollowSymLinks = false;
                continue;
            }
            if (option == SKIP_ROOT) {
                this.mySkipRoot = true;
                continue;
            }
            if (!(option instanceof Option.LimitOption)) continue;
            this.myDepthLimit = ((Option.LimitOption)option).limit;
        }
    }

    @NotNull
    public static Option limit(int maxDepth) {
        return new Option.LimitOption(maxDepth);
    }

    public static Result skipTo(@NotNull VirtualFile parentToSkipTo) {
        return new Result(true, parentToSkipTo);
    }

    public boolean visitFile(@NotNull VirtualFile file2) {
        return true;
    }

    @NotNull
    public Result visitFileEx(@NotNull VirtualFile file2) {
        return this.visitFile(file2) ? CONTINUE : SKIP_CHILDREN;
    }

    public void afterChildrenVisited(@NotNull VirtualFile file2) {
    }

    @Nullable
    public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
        return null;
    }

    public final void setValueForChildren(@Nullable T value) {
        this.myValue = value;
        if (this.myValueStack == null) {
            this.myValueStack = new Stack();
        }
    }

    public final T getCurrentValue() {
        return this.myValue;
    }

    final boolean allowVisitFile(@NotNull VirtualFile file2) {
        return this.myLevel > 0 || !this.mySkipRoot;
    }

    final boolean allowVisitChildren(@NotNull VirtualFile file2) {
        if (!file2.is(VFileProperty.SYMLINK)) {
            return true;
        }
        if (!this.myFollowSymLinks) {
            return false;
        }
        return !file2.isRecursiveOrCircularSymlink();
    }

    final boolean depthLimitReached() {
        return this.myDepthLimit >= 0 && this.myLevel >= this.myDepthLimit;
    }

    final void saveValue() {
        ++this.myLevel;
        if (this.myValueStack != null) {
            this.myValueStack.push(this.myValue);
        }
    }

    final void restoreValue(boolean pushed) {
        if (pushed) {
            --this.myLevel;
            if (this.myValueStack != null && !this.myValueStack.isEmpty()) {
                this.myValueStack.pop();
            }
        }
        if (this.myValueStack != null) {
            this.myValue = this.myValueStack.isEmpty() ? null : this.myValueStack.peek();
        }
    }

    protected static class VisitorException
    extends RuntimeException {
        public VisitorException(@NotNull Throwable cause) {
            super(cause);
        }
    }

    public static final class Result {
        public final boolean skipChildren;
        public final VirtualFile skipToParent;

        private Result(boolean skipChildren, @Nullable VirtualFile skipToParent) {
            this.skipChildren = skipChildren;
            this.skipToParent = skipToParent;
        }

        @NonNls
        public String toString() {
            return "(" + (this.skipChildren ? "skip," + this.skipToParent : "continue") + ")";
        }
    }

    public static class Option {
        private Option() {
        }

        private static final class LimitOption
        extends Option {
            private final int limit;

            private LimitOption(int limit) {
                this.limit = limit;
            }
        }
    }
}

