/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.model.ModelBranchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileSetFactory;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtilCore.class);
    @NonNls
    private static final String MAILTO = "mailto";
    @NonNls
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    public static final String VFS_SEPARATOR = "/";
    private static final String PROTOCOL_DELIMITER = ":";
    private static final NotNullLazyValue<VirtualFileSetFactory> VIRTUAL_FILE_SET_FACTORY = NotNullLazyValue.lazy(VirtualFileSetFactory::getInstance);

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file2, boolean strict) {
        VirtualFile parent;
        if (!file2.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file2.getParent() : file2;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file2, @Nullable Set<? extends VirtualFile> roots) {
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file2; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull @NonNls String url, @Nullable @NonNls Collection<String> rootUrls) {
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull @NonNls String ancestorUrl, @NotNull @NonNls String fileUrl) {
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar(ancestorUrl, '/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation(fileUrl, ancestorUrl, VFS_SEPARATOR);
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file2, boolean strict) {
        return FileUtil.isAncestor(ancestor, file2, strict);
    }

    @Nullable
    @NlsSafe
    public static String getRelativeLocation(@Nullable VirtualFile file2, @NotNull VirtualFile root) {
        if (file2 == null) {
            return null;
        }
        String path = VfsUtilCore.getRelativePath(file2, root);
        return path != null ? path : file2.getPresentableUrl();
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file2, @NotNull VirtualFile ancestor) {
        return VfsUtilCore.getRelativePath(file2, ancestor, '/');
    }

    @Nullable
    @NlsSafe
    public static String getRelativePath(@NotNull VirtualFile file2, @NotNull VirtualFile ancestor, char separator) {
        if (!file2.getFileSystem().equals(ancestor.getFileSystem())) {
            ModelBranchUtil.checkSameBranch(file2, ancestor);
            return null;
        }
        int length = 0;
        VirtualFile parent = file2;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file2;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            ModelBranchUtil.checkSameBranch(src, dst);
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor(src, dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
            while (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath(dst, commonAncestor, separatorChar));
        if (StringUtil.endsWithChar(buffer, separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        return VfsUtilCore.copyFile(requestor, file2, toDir, file2.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file2.contentsToByteArray(), -1L, -1L, requestor);
        newChild.setBOM(file2.getBOM());
        return newChild;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(byte @NotNull [] buf, @NotNull VirtualFile file2) throws IOException {
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)((Object)stream), file2);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file2) throws IOException {
        return CharsetToolkit.inputStreamSkippingBOM(stream);
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file2) throws IOException {
        byte[] bom = file2.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        return stream;
    }

    public static boolean iterateChildrenRecursively(@NotNull VirtualFile root, @Nullable VirtualFileFilter filter, @NotNull ContentIterator iterator) {
        return VfsUtilCore.iterateChildrenRecursively(root, filter, iterator, new VirtualFileVisitor.Option[0]);
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator, VirtualFileVisitor.Option ... options) {
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(options){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (filter != null && !filter.accept(file2)) {
                    return SKIP_CHILDREN;
                }
                if (!iterator.processFile(file2)) {
                    return 1.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file2, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        ProgressManager.checkCanceled();
        boolean pushed = false;
        try {
            boolean allowVisitFile = visitor.allowVisitFile(file2);
            if (allowVisitFile) {
                VirtualFileVisitor.Result result = visitor.visitFileEx(file2);
                if (result.skipChildren) {
                    VirtualFileVisitor.Result result2 = result;
                    return result2;
                }
            }
            Iterable<VirtualFile> childrenIterable = null;
            VirtualFile[] children2 = null;
            try {
                if (file2.isValid() && visitor.allowVisitChildren(file2) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file2)) == null) {
                    children2 = file2.getChildren();
                }
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.info("Ignoring: " + e.getMessage());
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                visitor.restoreValue(pushed);
                return result;
            }
            if (childrenIterable != null) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : childrenIterable) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result3 = result;
                    return result3;
                }
            } else if (children2 != null && children2.length != 0) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : children2) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result4 = result;
                    return result4;
                }
            }
            if (allowVisitFile) {
                visitor.afterChildrenVisited(file2);
            }
            VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
            return result;
        }
        finally {
            visitor.restoreValue(pushed);
        }
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file2, @NotNull VirtualFileVisitor<?> visitor, @NotNull Class<E> eClass) throws E {
        try {
            return VfsUtilCore.visitChildrenRecursively(file2, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file2) {
        return file2.is(VFileProperty.SYMLINK) && file2.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file2) throws IOException {
        return VfsUtilCore.loadText(file2, (int)file2.getLength());
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file2, int length) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(file2.getInputStream(), file2.getCharset());){
            String string2 = new String(FileUtilRt.loadText((Reader)reader, (int)length));
            return string2;
        }
    }

    public static byte @NotNull [] loadBytes(@NotNull VirtualFile file2) throws IOException {
        return FileUtilRt.isTooLarge((long)file2.getLength()) ? FileUtil.loadFirstAndClose(file2.getInputStream(), FileUtilRt.LARGE_FILE_PREVIEW_SIZE) : file2.contentsToByteArray();
    }

    public static VirtualFile @NotNull [] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files2) {
        return files2.isEmpty() ? VirtualFile.EMPTY_ARRAY : files2.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @NotNull
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        return URLUtil.urlToPath(url);
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file2) {
        return new File(PathUtil.toPresentableUrl(file2.getUrl()));
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        return VirtualFileManager.constructUrl("file", FileUtil.toSystemIndependentName(path));
    }

    @NotNull
    public static String fileToUrl(@NotNull File file2) {
        return VfsUtilCore.pathToUrl(file2.getPath());
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<? extends VirtualFile> files2) {
        return ContainerUtil.map2List(files2, file2 -> VfsUtilCore.virtualToIoFile(file2));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index = url.indexOf(":/");
        if (index < 0 || index + 2 >= url.length()) {
            return url;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfoRt.isWindows) {
                return prefix + "://" + suffix;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                return prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
            }
            return prefix + ":///" + suffix;
        }
        if (SystemInfoRt.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                return "file://" + url.substring(index + 4);
            }
            return url;
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation(path, "file", PROTOCOL_DELIMITER)) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(CoreBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(CoreBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfoRt.isWindows) {
            while (!path.isEmpty() && path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        path = URLUtil.unescapePercentSequences(path);
        return protocol + "://" + path;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path);
            }
            return URLUtil.internProtocol(new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        String ideaProtocolMarker = "://";
        int idx = ideaUrl.indexOf(ideaProtocolMarker);
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + ideaProtocolMarker.length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith(VFS_SEPARATOR) ? "" : VFS_SEPARATOR) + urlWithoutProtocol;
        }
        return ideaUrl;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull @NonNls String uri, @Nullable VirtualFile base) {
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else {
            uri = StringUtil.trimStart(uri, "file:");
        }
        VirtualFile file2 = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfoRt.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
            file2 = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (SystemInfoRt.isUnix && uri.startsWith(VFS_SEPARATOR) || SystemInfoRt.isWindows && (OSAgnosticPathUtil.isAbsoluteDosPath(uri) || OSAgnosticPathUtil.isUncPath(uri))) {
            file2 = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file2 == null && uri.contains("!/") && (file2 = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file2 = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file2 == null) {
            if (base != null && !base.isDirectory()) {
                base = base.getParent();
            }
            file2 = base == null ? StandardFileSystems.local().findFileByPath(uri) : VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + '/' + uri);
        }
        return file2;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        final Ref result = new Ref((Object)true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (!processor.process(file2)) {
                    result.set((Object)Boolean.FALSE);
                    return 2.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile parent1;
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        if (file1.equals(file2)) {
            return file1;
        }
        int depth1 = VfsUtilCore.depth(file1);
        int depth2 = VfsUtilCore.depth(file2);
        VirtualFile parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int depth(VirtualFile file2) {
        int depth = 0;
        while (file2 != null) {
            ++depth;
            file2 = file2.getParent();
        }
        return depth;
    }

    static VirtualFile @NotNull [] getPathComponents(@NotNull VirtualFile file2) {
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file2 != null) {
            componentsList.add(file2);
            file2 = file2.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        return components;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<? extends VirtualFile> files2) {
        for (VirtualFile virtualFile : files2) {
            if (virtualFile.isValid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findContainingDirectory(@NotNull VirtualFile file2, @NotNull CharSequence name) {
        VirtualFile parent;
        VirtualFile virtualFile = parent = file2.isDirectory() ? file2 : file2.getParent();
        while (parent != null) {
            if (StringUtilRt.equal((CharSequence)parent.getNameSequence(), (CharSequence)name, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @ApiStatus.Experimental
    public static boolean pathEqualsTo(@NotNull VirtualFile file2, @NotNull @SystemIndependent String path) {
        path = FileUtil.toCanonicalPath(path);
        int li = path.length();
        while (file2 != null && li != -1) {
            int sepIndex = path.lastIndexOf(47, li - 1);
            CharSequence fileName = file2.getNameSequence();
            int fileNameEnd = fileName.length() + (StringUtil.endsWithChar(fileName, '/') ? -1 : 0);
            if (sepIndex == 6 && StringUtil.startsWith(fileName, "//wsl$")) {
                sepIndex = -1;
            }
            if (!CharArrayUtil.regionMatches(fileName, 0, fileNameEnd, path, sepIndex + 1, li, file2.isCaseSensitive())) {
                return false;
            }
            file2 = file2.getParent();
            li = sepIndex;
        }
        return li == -1 && file2 == null;
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file2) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        while (file2 != null) {
            result.add(file2);
            file2 = file2.getParent();
        }
        return result;
    }

    @ApiStatus.Experimental
    public static boolean isAncestorOrSelf(@NotNull @SystemIndependent String ancestorPath, @NotNull VirtualFile file2) {
        ancestorPath = FileUtil.toCanonicalPath(ancestorPath);
        List<VirtualFile> hierarchy = VfsUtilCore.getHierarchy(file2);
        if (ancestorPath.isEmpty()) {
            return true;
        }
        int i = 0;
        boolean result = false;
        for (int j = hierarchy.size() - 1; j >= 0; --j) {
            boolean matches;
            VirtualFile part = hierarchy.get(j);
            String name = part.getName();
            boolean bl = matches = part.isCaseSensitive() ? StringUtil.startsWith(ancestorPath, i, name) : StringUtilRt.startsWithIgnoreCase((String)ancestorPath, (int)i, (String)name);
            if (!matches) break;
            i += name.length();
            if (!name.endsWith(VFS_SEPARATOR)) {
                if (i != ancestorPath.length() && ancestorPath.charAt(i) != '/') break;
                ++i;
            }
            if (i < ancestorPath.length()) continue;
            result = true;
            break;
        }
        return result;
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file2) {
        VirtualFile parent;
        while ((parent = file2.getParent()) != null) {
            file2 = parent;
        }
        return file2;
    }

    @NotNull
    public static VirtualFileSet createCompactVirtualFileSet() {
        return VIRTUAL_FILE_SET_FACTORY.getValue().createCompactVirtualFileSet();
    }

    @NotNull
    public static VirtualFileSet createCompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files2) {
        return VIRTUAL_FILE_SET_FACTORY.getValue().createCompactVirtualFileSet(files2);
    }

    public static final class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection(@NotNull Collection<? extends VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile @NotNull [] collection) {
            super(collection);
        }

        @Override
        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
            return VfsUtilCore.isAncestor(ancestor, virtualFile, false);
        }
    }
}

