/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ReadonlyStatusHandlerBase
extends ReadonlyStatusHandler {
    private static final Logger LOG = Logger.getInstance(ReadonlyStatusHandlerBase.class);
    private final Project myProject;

    public ReadonlyStatusHandlerBase(Project project) {
        this.myProject = project;
    }

    private static void checkThreading() {
        Application app = ApplicationManager.getApplication();
        app.assertIsWriteThread();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is("tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    protected static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> originalFiles, @NotNull Collection<? extends VirtualFile> files2) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        assert (!readOnlyFiles.isEmpty() || ContainerUtil.and(originalFiles, file2 -> file2 == null || file2.isWritable())) : "Original files: " + originalFiles + ", files: " + files2;
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles) {
        OperationStatusImpl operationStatusImpl;
        if (originalFiles.isEmpty()) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ReadonlyStatusHandlerBase.checkThreading();
        HashSet<void> realFiles = new HashSet<void>(originalFiles.size());
        for (VirtualFile virtualFile : originalFiles) {
            void var4_4;
            void var4_9;
            void var4_7;
            VirtualFile originalFile;
            if (virtualFile instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile).getOriginalFile()) != null) {
                VirtualFile virtualFile2 = originalFile;
            }
            if (var4_7 instanceof VirtualFileWindow) {
                VirtualFile virtualFile3 = ((VirtualFileWindow)var4_7).getDelegate();
            }
            if (var4_9 instanceof BackedVirtualFile) {
                VirtualFile virtualFile4 = ((BackedVirtualFile)var4_9).getOriginFile();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        ArrayList files2 = new ArrayList(realFiles);
        if (!this.myProject.isDefault() && (operationStatusImpl = WritingAccessProvider.EP.computeSafeIfAny(this.myProject, provider -> {
            Collection<Object> denied = ContainerUtil.filter(files2, virtualFile -> !provider.isPotentiallyWritable((VirtualFile)virtualFile));
            if (denied.isEmpty()) {
                denied = provider.requestWriting(files2);
            }
            if (!denied.isEmpty()) {
                return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(denied), provider.getReadOnlyMessage());
            }
            return null;
        })) != null) {
            return operationStatusImpl;
        }
        return this.ensureFilesWritable(originalFiles, files2);
    }

    @NotNull
    protected ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles, Collection<? extends VirtualFile> files2) {
        return ReadonlyStatusHandlerBase.createResultStatus(originalFiles, files2);
    }

    public static final class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        @NotNull
        private final @NlsContexts.DialogMessage String myReadOnlyReason;

        public OperationStatusImpl(VirtualFile @NotNull [] readonlyFiles) {
            this(readonlyFiles, "");
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull @NlsContexts.DialogMessage String readOnlyReason) {
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
        }

        @Override
        public VirtualFile @NotNull [] getReadonlyFiles() {
            return this.myReadonlyFiles;
        }

        @Override
        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @Override
        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!Strings.isEmpty(this.myReadOnlyReason)) {
                    return this.myReadOnlyReason;
                }
                if (this.myReadonlyFiles.length > 1) {
                    StringBuilder buf = new StringBuilder();
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    return CoreBundle.message("failed.to.make.the.following.files.writable.error.message", buf.toString());
                }
                return CoreBundle.message("failed.to.make.file.writable.error.message", this.myReadonlyFiles[0].getPresentableUrl());
            }
            throw new RuntimeException("No readonly files");
        }
    }
}

