/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ReadonlyStatusHandler {
    public static ReadonlyStatusHandler getInstance(@NotNull Project project) {
        return project.getService(ReadonlyStatusHandler.class);
    }

    public static boolean ensureFilesWritable(@NotNull Project project, VirtualFile ... files2) {
        return !ReadonlyStatusHandler.getInstance(project).ensureFilesWritable(Arrays.asList(files2)).hasReadonlyFiles();
    }

    public static boolean ensureDocumentWritable(@NotNull Project project, @NotNull Document document) {
        VirtualFile virtualFile;
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        boolean okWritable = psiFile == null ? document.isWritable() : ((virtualFile = psiFile.getVirtualFile()) != null ? ReadonlyStatusHandler.ensureFilesWritable(project, virtualFile) : psiFile.isWritable());
        return okWritable;
    }

    @Deprecated
    @NotNull
    public OperationStatus ensureFilesWritable(VirtualFile ... files2) {
        return this.ensureFilesWritable(Arrays.asList(files2));
    }

    @NotNull
    public abstract OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> var1);

    public static abstract class OperationStatus {
        public abstract VirtualFile @NotNull [] getReadonlyFiles();

        public abstract boolean hasReadonlyFiles();

        @NotNull
        @NlsContexts.DialogMessage
        public abstract String getReadonlyFilesMessage();
    }
}

