/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    public InvalidVirtualFileAccessException(@NotNull VirtualFile file2) {
        super(InvalidVirtualFileAccessException.composeMessage(file2));
    }

    public InvalidVirtualFileAccessException(@NotNull String message) {
        super(message);
    }

    @NonNls
    private static String composeMessage(@NotNull VirtualFile file2) {
        String url = file2.getUrl();
        @NonNls String message = "Accessing invalid virtual file: " + url;
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file2) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file2.isInLocalFileSystem()) {
                boolean physicalExists = new File(file2.getPath()).exists();
                message = message + "; File.exists()=" + physicalExists;
            } else {
                message = message + "; file system=" + file2.getFileSystem();
            }
        }
        catch (Throwable t) {
            message = message + "; lookup failed: " + t.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o) {
        return o == null ? "-" : String.valueOf(o.hashCode());
    }
}

