/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            MessageBusConnection connection;
            ExtensionPoint extensionPoint = app.getExtensionArea().getExtensionPointIfRegistered(VirtualFileSystem.EP_NAME.getName());
            if (extensionPoint != null) {
                Disposable extensionDisposable = ExtensionPointUtil.createExtensionDisposable(this, extensionPoint, ep -> ep.getKey().equals(this.getProtocol()));
                connection = app.getMessageBus().connect(extensionDisposable);
            } else {
                connection = app.getMessageBus().connect();
            }
            connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myEventDispatcher.getMulticaster(), this));
        }
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        this.myEventDispatcher.addListener(listener);
    }

    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        this.myEventDispatcher.removeListener(listener);
    }

    protected void firePropertyChanged(Object requestor, @NotNull VirtualFile file2, @NotNull String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file2, propertyName, oldValue, newValue);
        this.myEventDispatcher.getMulticaster().propertyChanged(event);
    }

    protected void fireContentsChanged(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file2, file2.getParent(), oldModificationStamp, file2.getModificationStamp());
        this.myEventDispatcher.getMulticaster().contentsChanged(event);
    }

    protected void fireFileCreated(@Nullable Object requestor, @NotNull VirtualFile file2) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file2, file2.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().fileCreated(event);
    }

    protected void fireFileDeleted(Object requestor, @NotNull VirtualFile file2, @NotNull String fileName, VirtualFile parent) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file2, parent, 0L, 0L);
        this.myEventDispatcher.getMulticaster().fileDeleted(event);
    }

    protected void fireFileMoved(Object requestor, @NotNull VirtualFile file2, VirtualFile oldParent) {
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file2, oldParent, file2.getParent());
        this.myEventDispatcher.getMulticaster().fileMoved(event);
    }

    protected void fireFileCopied(@Nullable Object requestor, @NotNull VirtualFile originalFile, @NotNull VirtualFile createdFile) {
        this.assertWriteAccessAllowed();
        VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
        this.myEventDispatcher.getMulticaster().fileCopied(event);
    }

    protected void fireBeforePropertyChange(Object requestor, @NotNull VirtualFile file2, @NotNull String propertyName, Object oldValue, Object newValue) {
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file2, propertyName, oldValue, newValue);
        this.myEventDispatcher.getMulticaster().beforePropertyChange(event);
    }

    protected void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file2) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file2, file2.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().beforeContentsChange(event);
    }

    protected void fireBeforeFileDeletion(Object requestor, @NotNull VirtualFile file2) {
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file2, file2.getParent(), 0L, 0L);
        this.myEventDispatcher.getMulticaster().beforeFileDeletion(event);
    }

    protected void fireBeforeFileMovement(Object requestor, @NotNull VirtualFile file2, VirtualFile newParent) {
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file2, file2.getParent(), newParent);
        this.myEventDispatcher.getMulticaster().beforeFileMovement(event);
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        throw this.unsupported("deleteFile", vFile);
    }

    @Override
    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        throw this.unsupported("move", vFile);
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        throw this.unsupported("renameFile", vFile);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        throw this.unsupported("createChildFile", vDir);
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        throw this.unsupported("createChildDirectory", vDir);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        throw this.unsupported("copyFile", vFile);
    }

    private UnsupportedOperationException unsupported(String op, VirtualFile vFile) {
        return new UnsupportedOperationException(op + '(' + vFile + ") not supported by " + this.getClass().getName());
    }
}

