/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlChunk {
    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull @NonNls String tagName) {
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.singletonList(this));
    }

    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull Element element) {
        return element.child(this);
    }

    @Contract(pure=true)
    @NotNull
    public Element code() {
        return this.wrapWith("code");
    }

    @Contract(pure=true)
    @NotNull
    public Element bold() {
        return this.wrapWith("b");
    }

    @Contract(pure=true)
    @NotNull
    public Element italic() {
        return this.wrapWith("i");
    }

    @Contract(pure=true)
    @NotNull
    public Element strikethrough() {
        return this.wrapWith("s");
    }

    @Contract(pure=true)
    @NotNull
    public static Element tag(@NotNull @NonNls String tagName) {
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static Element div() {
        return Element.DIV;
    }

    @Contract(pure=true)
    @NotNull
    public static Element div(@NotNull @NonNls String style) {
        return Element.DIV.style(style);
    }

    @Contract(pure=true)
    @NotNull
    public static Element span() {
        return Element.SPAN;
    }

    @Contract(pure=true)
    @NotNull
    public static Element span(@NonNls @NotNull String style) {
        return Element.SPAN.style(style);
    }

    @Contract(pure=true)
    @NotNull
    public static Element br() {
        return Element.BR;
    }

    @Contract(pure=true)
    @NotNull
    public static Element li() {
        return Element.LI;
    }

    @Contract(pure=true)
    @NotNull
    public static Element ul() {
        return Element.UL;
    }

    @Contract(pure=true)
    @NotNull
    public static Element hr() {
        return Element.HR;
    }

    @Contract(pure=true)
    @NotNull
    public static Element p() {
        return Element.P;
    }

    @Contract(pure=true)
    @NotNull
    public static Element head() {
        return Element.HEAD;
    }

    @NotNull
    public static Element styleTag(@NonNls @NotNull String style) {
        return HtmlChunk.tag("style").addRaw(style);
    }

    @NotNull
    public static Element font(@NonNls @NotNull String color) {
        return HtmlChunk.tag("font").attr("color", color);
    }

    @NotNull
    public static Element font(int size) {
        return HtmlChunk.tag("font").attr("size", String.valueOf(size));
    }

    @Contract(pure=true)
    @NotNull
    public static Element body() {
        return Element.BODY;
    }

    @Contract(pure=true)
    @NotNull
    public static Element html() {
        return Element.HTML;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp() {
        return Nbsp.ONE;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk nbsp(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        return new Nbsp(count);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk text(@NotNull @Nls String text) {
        return text.isEmpty() ? HtmlChunk.empty() : new Text(text);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk empty() {
        return Empty.INSTANCE;
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk raw(@NotNull @Nls String rawHtml) {
        return rawHtml.isEmpty() ? HtmlChunk.empty() : new Raw(rawHtml);
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull @Nls String text) {
        return HtmlChunk.link(target, HtmlChunk.text(text));
    }

    @Contract(pure=true)
    @NotNull
    public static Element link(@NotNull @NonNls String target, @NotNull HtmlChunk text) {
        return new Element("a", UnmodifiableHashMap.empty().with("href", target), Collections.singletonList(text));
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk htmlEntity(@NotNull @NlsSafe String htmlEntity) {
        if (!htmlEntity.startsWith("&") && !htmlEntity.endsWith(";")) {
            throw new IllegalArgumentException("Not an entity: " + htmlEntity);
        }
        return HtmlChunk.raw(htmlEntity);
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return false;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk fragment(HtmlChunk ... chunks) {
        if (chunks.length == 0) {
            return HtmlChunk.empty();
        }
        return Arrays.stream(chunks).collect(HtmlChunk.toFragment());
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment() {
        return Collector.of(HtmlBuilder::new, HtmlBuilder::append, HtmlBuilder::append, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<HtmlChunk, ?, HtmlChunk> toFragment(HtmlChunk separator) {
        return Collector.of(HtmlBuilder::new, (hb, c) -> {
            if (!hb.isEmpty()) {
                hb.append(separator);
            }
            hb.append((HtmlChunk)c);
        }, (hb1, hb2) -> {
            if (!hb1.isEmpty()) {
                hb1.append(separator);
            }
            return hb1.append((HtmlBuilder)hb2);
        }, HtmlBuilder::toFragment, new Collector.Characteristics[0]);
    }

    public static class Element
    extends HtmlChunk {
        private static final Element HEAD = Element.tag("head");
        private static final Element BODY = Element.tag("body");
        private static final Element HTML = Element.tag("html");
        private static final Element BR = Element.tag("br");
        private static final Element UL = Element.tag("ul");
        private static final Element LI = Element.tag("li");
        private static final Element HR = Element.tag("hr");
        private static final Element P = Element.tag("p");
        private static final Element DIV = Element.tag("div");
        private static final Element SPAN = Element.tag("span");
        private final String myTagName;
        private final UnmodifiableHashMap<String, String> myAttributes;
        private final List<HtmlChunk> myChildren;

        private Element(String name, UnmodifiableHashMap<String, String> attributes, List<HtmlChunk> children2) {
            this.myTagName = name;
            this.myAttributes = attributes;
            this.myChildren = children2;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            builder.append('<').append(this.myTagName);
            this.myAttributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> builder.append(' ').append((String)entry.getKey()).append("=\"").append(StringUtil.escapeXmlEntities((String)entry.getValue())).append('\"'));
            if (this.myChildren.isEmpty()) {
                builder.append("/>");
            } else {
                builder.append(">");
                for (HtmlChunk child : this.myChildren) {
                    child.appendTo(builder);
                }
                builder.append("</").append(this.myTagName).append(">");
            }
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, String value) {
            return new Element(this.myTagName, this.myAttributes.with(name, value), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element attr(@NonNls String name, int value) {
            return new Element(this.myTagName, this.myAttributes.with(name, Integer.toString(value)), this.myChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element style(@NonNls String style) {
            return this.attr("style", style);
        }

        @Contract(pure=true)
        @NotNull
        public Element setClass(@NonNls String className) {
            return this.attr("class", className);
        }

        @Contract(pure=true)
        @NotNull
        public Element addText(@NotNull @Nls String text) {
            return this.child(Element.text(text));
        }

        @Contract(pure=true)
        @NotNull
        public Element addRaw(@NotNull @Nls String text) {
            return this.child(Element.raw(text));
        }

        @Contract(pure=true)
        @NotNull
        public Element children(HtmlChunk ... chunks) {
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Arrays.asList(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.length);
            newChildren.addAll(this.myChildren);
            Collections.addAll(newChildren, chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element children(@NotNull List<? extends HtmlChunk> chunks) {
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, new ArrayList<HtmlChunk>(chunks));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + chunks.size());
            newChildren.addAll(this.myChildren);
            newChildren.addAll(chunks);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        @Contract(pure=true)
        @NotNull
        public Element child(@NotNull HtmlChunk chunk) {
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Collections.singletonList(chunk));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + 1);
            newChildren.addAll(this.myChildren);
            newChildren.add(chunk);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }
    }

    private static class Nbsp
    extends HtmlChunk {
        private static final HtmlChunk ONE = new Nbsp(1);
        private final int myCount;

        private Nbsp(int count) {
            this.myCount = count;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            builder.append(StringUtil.repeat("&nbsp;", this.myCount));
        }
    }

    static class Fragment
    extends HtmlChunk {
        private final List<? extends HtmlChunk> myContent;

        Fragment(List<? extends HtmlChunk> content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            for (HtmlChunk htmlChunk : this.myContent) {
                htmlChunk.appendTo(builder);
            }
        }
    }

    private static class Raw
    extends HtmlChunk {
        private final String myContent;

        private Raw(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            builder.append(this.myContent);
        }
    }

    private static class Text
    extends HtmlChunk {
        private final String myContent;

        private Text(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            builder.append(StringUtil.escapeXmlEntities(this.myContent).replaceAll("\n", "<br/>"));
        }
    }

    private static class Empty
    extends HtmlChunk {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
        }
    }
}

