/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io.win32;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.util.loader.NativeLibraryLoader;
import com.intellij.util.system.CpuArch;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaWin32 {
    private static final Logger LOG = Logger.getInstance(IdeaWin32.class);
    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();
    private static final IdeaWin32 ourInstance;

    private static boolean loadBundledLibrary() throws IOException {
        String name = CpuArch.isIntel64() ? "IdeaWin64" : "IdeaWin32";
        URL bundled = IdeaWin32.class.getResource(name + ".dll");
        if (bundled == null) {
            return false;
        }
        byte[] content = FileUtilRt.loadBytes((InputStream)bundled.openStream());
        CRC32 crc32 = new CRC32();
        crc32.update(content, 0, content.length);
        long hash = Math.abs(crc32.getValue());
        Path file2 = Paths.get(FileUtilRt.getTempDirectory(), name + '.' + hash + ".dll");
        if (!Files.exists(file2, new LinkOption[0])) {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.write(file2, content, new OpenOption[0]);
        }
        System.load(file2.toString());
        return true;
    }

    public static boolean isAvailable() {
        return ourInstance != null;
    }

    @NotNull
    public static IdeaWin32 getInstance() {
        if (!IdeaWin32.isAvailable()) {
            throw new IllegalStateException("Native filesystem for Windows is not loaded");
        }
        return ourInstance;
    }

    private IdeaWin32() {
        IdeaWin32.initIDs();
    }

    private static native void initIDs();

    @Nullable
    public FileInfo getInfo(@NotNull String path) {
        path = path.replace('/', '\\');
        if (TRACE_ENABLED) {
            LOG.trace("getInfo(" + path + ")");
            long t = System.nanoTime();
            FileInfo result = this.getInfo0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.trace("  " + t + " mks");
            return result;
        }
        return this.getInfo0(path);
    }

    @Nullable
    public String resolveSymLink(@NotNull String path) {
        path = path.replace('/', '\\');
        if (TRACE_ENABLED) {
            LOG.trace("resolveSymLink(" + path + ")");
            long t = System.nanoTime();
            String result = this.resolveSymLink0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.trace("  " + t + " mks");
            return result;
        }
        return this.resolveSymLink0(path);
    }

    public FileInfo @Nullable [] listChildren(@NotNull String path) {
        path = path.replace('/', '\\');
        if (TRACE_ENABLED) {
            LOG.trace("list(" + path + ")");
            long t = System.nanoTime();
            FileInfo[] children2 = this.listChildren0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.trace("  " + (children2 == null ? -1 : children2.length) + " children, " + t + " mks");
            return children2;
        }
        return this.listChildren0(path);
    }

    private native FileInfo getInfo0(String var1);

    private native String resolveSymLink0(String var1);

    private native FileInfo[] listChildren0(String var1);

    static {
        IdeaWin32 instance = null;
        if (SystemInfoRt.isWindows && Boolean.parseBoolean(System.getProperty("idea.use.native.fs.for.win", "true"))) {
            try {
                if (!IdeaWin32.loadBundledLibrary()) {
                    NativeLibraryLoader.loadPlatformLibrary("IdeaWin32");
                }
                instance = new IdeaWin32();
                LOG.info("Native filesystem for Windows is operational");
            }
            catch (Throwable t) {
                LOG.warn("Failed to initialize native filesystem for Windows", t);
            }
        }
        ourInstance = instance;
    }
}

