/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class PathExecLazyValue {
    private PathExecLazyValue() {
    }

    @NotNull
    public static NotNullLazyValue<Boolean> create(@NlsSafe @NotNull String name) {
        if (Strings.containsAnyChar(name, "/\\")) {
            throw new IllegalArgumentException(name);
        }
        return NotNullLazyValue.atomicLazy(() -> {
            String path = EnvironmentUtil.getValue("PATH");
            if (path != null) {
                for (String dir : StringUtil.tokenize(path, File.pathSeparator)) {
                    if (!new File(dir, name).canExecute()) continue;
                    return true;
                }
            }
            return false;
        });
    }
}

