/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NioFiles {
    private NioFiles() {
    }

    @Nullable
    public static Path toPath(@NotNull String path) {
        try {
            return Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull Path path) {
        Path name = path.getFileName();
        return (name != null ? name : path).toString();
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        try {
            NioFiles.tryCreateDirectory(path);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (IOException e) {
            Path parent = path.getParent();
            if (parent == null) {
                throw e;
            }
            NioFiles.createDirectories(parent);
            NioFiles.tryCreateDirectory(path);
        }
        return path;
    }

    private static void tryCreateDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixView != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file2) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view = Files.getFileAttributeView(file2, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        try {
            ArrayList<Path> files2 = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files2.add(path);
                }
            }
            return files2;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        FileUtilRt.deleteRecursivelyNIO((Object)fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<? super Path> callback) throws IOException {
        FileUtilRt.deleteRecursivelyNIO((Object)fileOrDirectory, o -> callback.accept((Path)o));
    }
}

