/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JarUtil {
    private static final Logger LOG = Logger.getInstance(JarUtil.class);

    public static boolean containsClass(@NotNull String jarPath, @NotNull String className) {
        return JarUtil.containsClass(new File(jarPath), className);
    }

    public static boolean containsClass(@NotNull File file2, String className) {
        String entryPath = className.replace('.', '/') + ".class";
        return JarUtil.containsEntry(file2, entryPath);
    }

    public static boolean containsEntry(File file2, String entryPath) {
        if (file2.canRead()) {
            boolean bl;
            JarFile jarFile = new JarFile(file2);
            try {
                bl = jarFile.getEntry(entryPath) != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            jarFile.close();
            return bl;
        }
        return false;
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull Attributes.Name attribute) {
        return JarUtil.getJarAttributeImpl(file2, null, attribute);
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull String entryName, @NotNull Attributes.Name attribute) {
        return JarUtil.getJarAttributeImpl(file2, entryName, attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file2, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (!file2.canRead()) return null;
        try (JarFile jarFile = new JarFile(file2);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return null;
            Attributes attributes = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
            String string2 = attributes.getValue(attribute);
            return string2;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadProperties(@NotNull File file2, @NotNull String entryName) {
        if (!file2.canRead()) return null;
        try (ZipFile zipFile = new ZipFile(file2);){
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) return null;
            Properties properties = new Properties();
            properties.load(zipFile.getInputStream(entry));
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }
}

