/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.UtilBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public class FileUtil
extends FileUtilRt {
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    public static final int REGEX_PATTERN_FLAGS = SystemInfoRt.isFileSystemCaseSensitive ? 0 : 2;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY = SystemInfoRt.isFileSystemCaseSensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY = new TObjectHashingStrategy<File>(){

        @Override
        public int computeHashCode(File object) {
            return FileUtil.fileHashCode(object);
        }

        @Override
        public boolean equals(File o1, File o2) {
            return FileUtil.filesEqual(o1, o2);
        }
    };
    private static final Logger LOG = Logger.getInstance(FileUtil.class);
    private static final FileUtilRt.SymlinkResolver SYMLINK_RESOLVER = new FileUtilRt.SymlinkResolver(){

        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String path, char separatorChar, boolean removeLastSlash) {
            try {
                return new File(path).getCanonicalPath().replace(separatorChar, '/');
            }
            catch (IOException ignore) {
                return FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, false);
            }
        }

        public boolean isSymlink(@NotNull CharSequence path) {
            return FileSystemUtil.isSymLink(new File(path.toString()));
        }
    };

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String join(String ... parts) {
        return String.join((CharSequence)File.separator, parts);
    }

    @Nullable
    @Contract(pure=true)
    @NlsSafe
    public static String getRelativePath(File base, File file2) {
        return FileUtilRt.getRelativePath((File)base, (File)file2);
    }

    @Nullable
    @Contract(pure=true)
    @NlsSafe
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        return FileUtilRt.getRelativePath((String)basePath, (String)filePath, (char)separator);
    }

    @Nullable
    @Contract(pure=true)
    @NlsSafe
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        return FileUtilRt.getRelativePath((String)basePath, (String)filePath, (char)separator, (boolean)caseSensitive);
    }

    public static boolean isAbsolute(@NotNull String path) {
        return !path.isEmpty() && new File(path).isAbsolute();
    }

    public static boolean exists(@Nullable String path) {
        return path != null && new File(path).exists();
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file2, boolean strict) {
        return FileUtil.isAncestor(ancestor.getPath(), file2.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull String ancestor, @NotNull String file2, boolean strict) {
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file2, strict));
    }

    @NotNull
    public static ThreeState isAncestorThreeState(@NotNull String ancestor, @NotNull String file2, boolean strict) {
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file2);
        return FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfoRt.isFileSystemCaseSensitive, true);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        return FileUtil.startsWith(path, prefix, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive) {
        return FileUtil.startsWith(path, prefix, isCaseSensitive, false);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull String path, @NotNull String prefix, boolean isCaseSensitive, boolean strict) {
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, prefix, strict, isCaseSensitive, false));
    }

    @NotNull
    @Contract(pure=true)
    private static ThreeState startsWith(@NotNull String path, @NotNull String prefix, boolean strict, boolean isCaseSensitive, boolean checkImmediateParent) {
        char next;
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (prefixLength > pathLength) {
            return ThreeState.NO;
        }
        if (!path.regionMatches(!isCaseSensitive, 0, prefix, 0, prefixLength)) {
            return ThreeState.NO;
        }
        if (pathLength == prefixLength) {
            return strict ? ThreeState.NO : ThreeState.YES;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next = path.charAt(slashOrSeparatorIdx)) == '/' || next == File.separatorChar) {
            if (!checkImmediateParent) {
                return ThreeState.YES;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                return ThreeState.YES;
            }
            int idxNext = path.indexOf(next, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            return idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    @Nullable
    @Contract(pure=true)
    public static File findAncestor(@NotNull File f1, @NotNull File f2) {
        File ancestor;
        for (ancestor = f1; ancestor != null && !FileUtil.isAncestor(ancestor, f2, false); ancestor = ancestor.getParentFile()) {
        }
        return ancestor;
    }

    @Nullable
    @Contract(pure=true)
    public static File getParentFile(@NotNull File file2) {
        return FileUtilRt.getParentFile((File)file2);
    }

    public static byte @NotNull [] loadFileBytes(@NotNull File file2) throws IOException {
        byte[] bytes;
        try (FileInputStream stream = new FileInputStream(file2);){
            long len = file2.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge((long)len)) {
                throw new FileTooBigException("Attempt to load '" + file2 + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        return bytes;
    }

    public static byte @NotNull [] loadFirstAndClose(@NotNull InputStream stream, int maxLength) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            FileUtil.copy(stream, maxLength, (OutputStream)buffer);
        }
        finally {
            stream.close();
        }
        return buffer.toByteArray();
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        return FileUtil.loadTextAndClose(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        try {
            String string2 = new String(FileUtil.adaptiveLoadText(reader));
            return string2;
        }
        finally {
            reader.close();
        }
    }

    public static char @NotNull [] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        return result;
    }

    public static byte @NotNull [] adaptiveLoadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        byte[] bytes = new byte[8192];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result = ArrayUtil.newByteArray(total);
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        return result;
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull File file2) {
        return FileUtil.asyncDelete(Collections.singleton(file2));
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull Collection<? extends File> files2) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file2 : files2) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file2);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        return tempFiles.isEmpty() ? CompletableFuture.completedFuture(null) : AppExecutorUtil.getAppExecutorService().submit(() -> {
            Thread currentThread = Thread.currentThread();
            int priority = currentThread.getPriority();
            currentThread.setPriority(1);
            try {
                for (File tempFile : tempFiles) {
                    FileUtil.delete(tempFile);
                }
            }
            finally {
                currentThread.setPriority(priority);
            }
            return null;
        });
    }

    @Nullable
    private static File renameToTempFileOrDelete(@NotNull File file2) {
        String originalFileName;
        File tempFile;
        String tempDir = FileUtil.getTempDirectory();
        boolean isSameDrive = true;
        if (SystemInfoRt.isWindows) {
            String tempDirDrive = tempDir.substring(0, 2);
            String fileDrive = file2.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file2.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file2.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file2);
        return null;
    }

    @NotNull
    private static File getTempFile(@NotNull String originalFileName, @NotNull String parent) {
        int randomSuffix;
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(@NotNull File file2) {
        return FileUtilRt.delete((File)file2);
    }

    public static void delete(@NotNull Path path) throws IOException {
        FileUtilRt.deleteRecursivelyNIO((Object)path, null);
    }

    public static boolean createParentDirs(@NotNull File file2) {
        return FileUtilRt.createParentDirs((File)file2);
    }

    public static boolean createDirectory(@NotNull File path) {
        return FileUtilRt.createDirectory((File)path);
    }

    public static boolean createIfDoesntExist(@NotNull File file2) {
        return FileUtilRt.createIfNotExists((File)file2);
    }

    public static boolean ensureCanCreateFile(@NotNull File file2) {
        return FileUtilRt.ensureCanCreateFile((File)file2);
    }

    public static void copy(@NotNull File fromFile, @NotNull File toFile2) throws IOException {
        FileUtil.performCopy(fromFile, toFile2, true);
    }

    public static void copyContent(@NotNull File fromFile, @NotNull File toFile2) throws IOException {
        FileUtil.performCopy(fromFile, toFile2, false);
    }

    private static void performCopy(@NotNull File fromFile, @NotNull File toFile2, boolean syncTimestamp) throws IOException {
        if (FileUtil.filesEqual(fromFile, toFile2)) {
            return;
        }
        try (FileOutputStream fos = FileUtil.openOutputStream(toFile2);
             FileInputStream fis = new FileInputStream(fromFile);){
            FileUtil.copy(fis, fos);
        }
        catch (IOException e) {
            throw new IOException(String.format("Couldn't copy [%s] to [%s]", fromFile, toFile2), e);
        }
        if (syncTimestamp) {
            long timeStamp = fromFile.lastModified();
            if (timeStamp < 0L) {
                LOG.warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
            } else if (!toFile2.setLastModified(timeStamp)) {
                LOG.warn("Unable to set timestamp " + timeStamp + " to '" + toFile2 + "'");
            }
        }
        if (SystemInfoRt.isUnix && fromFile.canExecute()) {
            FileSystemUtil.clonePermissionsToExecute(fromFile.getPath(), toFile2.getPath());
        }
    }

    @NotNull
    private static FileOutputStream openOutputStream(@NotNull File file2) throws IOException {
        try {
            return new FileOutputStream(file2);
        }
        catch (FileNotFoundException e) {
            File parentFile = file2.getParentFile();
            if (parentFile == null) {
                throw new IOException("Parent file is null for " + file2.getPath(), e);
            }
            FileUtil.createParentDirs(file2);
            return new FileOutputStream(file2);
        }
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        FileUtilRt.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    public static void copy(@NotNull InputStream inputStream, int maxSize, @NotNull OutputStream outputStream) throws IOException {
        FileUtil.copy(inputStream, (long)maxSize, outputStream);
    }

    public static void copy(@NotNull InputStream inputStream, long maxSize, @NotNull OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        for (long toRead = maxSize; toRead > 0L && (read = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, toRead))) >= 0; toRead -= (long)read) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to) throws IOException {
        FileUtil.copyFileOrDir(from, to, from.isDirectory());
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to, boolean isDir) throws IOException {
        if (isDir) {
            FileUtil.copyDir(from, to);
        } else {
            FileUtil.copy(from, to);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        File[] children2;
        for (File child : children2 = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtilRt.EMPTY_FILE_ARRAY)) {
            FileUtil.copyFileOrDir(child, new File(toDir, child.getName()));
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, boolean copySystemFiles) throws IOException {
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : file2 -> !StringUtil.startsWithChar(file2.getName(), '.'));
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter filter) throws IOException {
        FileUtil.ensureExists(toDir);
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files2 = fromDir.listFiles();
        if (files2 == null) {
            throw new IOException(UtilBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(UtilBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file2 : files2) {
            if (filter != null && !filter.accept(file2)) continue;
            if (file2.isDirectory()) {
                FileUtil.copyDir(file2, new File(toDir, file2.getName()), filter);
                continue;
            }
            FileUtil.copy(file2, new File(toDir, file2.getName()));
        }
    }

    public static void ensureExists(@NotNull File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(UtilBundle.message("exception.directory.can.not.create", dir.getPath()));
        }
    }

    @NotNull
    @NlsSafe
    public static String getNameWithoutExtension(@NotNull File file2) {
        return FileUtilRt.getNameWithoutExtension((String)file2.getName());
    }

    @NotNull
    @NlsSafe
    public static String getNameWithoutExtension(@NotNull String name) {
        return FileUtilRt.getNameWithoutExtension((String)name);
    }

    @NotNull
    @NlsSafe
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension) {
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    @NotNull
    @NlsSafe
    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension, @NotNull Predicate<? super File> condition) {
        return FileUtil.findSequentFile(aParentFolder, aFilePrefix, aExtension, condition).getName();
    }

    @NotNull
    public static File findSequentNonexistentFile(@NotNull File parentFolder, @NotNull @NonNls String filePrefix, @NotNull String extension) {
        return FileUtil.findSequentFile(parentFolder, filePrefix, extension, file2 -> !file2.exists());
    }

    @NotNull
    public static File findSequentFile(@NotNull File parentFolder, @NotNull String filePrefix, @NotNull String extension, @NotNull Predicate<? super File> condition) {
        int postfix = 0;
        String ext = extension.isEmpty() ? "" : '.' + extension;
        File candidate = new File(parentFolder, filePrefix + ext);
        while (!condition.test(candidate)) {
            candidate = new File(parentFolder, filePrefix + ++postfix + ext);
        }
        return candidate;
    }

    @NotNull
    @NlsSafe
    public static String toSystemDependentName(@NotNull String filePath) {
        return FileUtilRt.toSystemDependentName((String)filePath);
    }

    @NotNull
    @NonNls
    public static String toSystemIndependentName(@NotNull String filePath) {
        return FileUtilRt.toSystemIndependentName((String)filePath);
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtil.toCanonicalPath((String)path, (char)File.separatorChar, (boolean)true);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, boolean resolveSymlinksIfNecessary) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true, resolveSymlinksIfNecessary);
    }

    @Contract(value="null, _ -> null; !null,_->!null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar) {
        return FileUtil.toCanonicalPath((String)path, (char)separatorChar, (boolean)true);
    }

    @Contract(value="null -> null; !null->!null")
    public static String toCanonicalUriPath(@Nullable String path) {
        return FileUtil.toCanonicalPath((String)path, (char)'/', (boolean)false);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash, boolean resolveSymlinks) {
        FileUtilRt.SymlinkResolver symlinkResolver = resolveSymlinks ? SYMLINK_RESOLVER : null;
        return FileUtil.toCanonicalPath((String)path, (char)separatorChar, (boolean)removeLastSlash, (FileUtilRt.SymlinkResolver)symlinkResolver);
    }

    @NotNull
    public static String normalize(@NotNull String path) {
        int start = 0;
        boolean separator = false;
        if (SystemInfoRt.isWindows) {
            if (path.startsWith("//")) {
                start = 2;
                separator = true;
            } else if (path.startsWith("\\\\")) {
                return FileUtil.normalizeTail(0, path, false);
            }
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (separator) {
                    return FileUtil.normalizeTail(i, path, true);
                }
                separator = true;
                continue;
            }
            if (c == '\\') {
                return FileUtil.normalizeTail(i, path, separator);
            }
            separator = false;
        }
        return path;
    }

    @NotNull
    private static String normalizeTail(int prefixEnd, @NotNull String path, boolean separator) {
        StringBuilder result = new StringBuilder(path.length());
        result.append(path, 0, prefixEnd);
        int start = prefixEnd;
        if (start == 0 && SystemInfoRt.isWindows && (path.startsWith("//") || path.startsWith("\\\\"))) {
            start = 2;
            result.append("//");
            separator = true;
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (!separator) {
                    result.append('/');
                }
                separator = true;
                continue;
            }
            result.append(c);
            separator = false;
        }
        return result.toString();
    }

    @NotNull
    @NlsSafe
    public static String unquote(@NotNull String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(urlString);
    }

    public static boolean rename(@NotNull File source, @NotNull String newName) throws IOException {
        File target = new File(source.getParent(), newName);
        if (!SystemInfoRt.isFileSystemCaseSensitive && newName.equalsIgnoreCase(source.getName())) {
            File intermediate = FileUtil.createTempFile(source.getParentFile(), source.getName(), ".tmp", false, false);
            return source.renameTo(intermediate) && intermediate.renameTo(target);
        }
        return source.renameTo(target);
    }

    public static void rename(@NotNull File source, @NotNull File target) throws IOException {
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return SystemInfoRt.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    public static boolean namesEqual(@Nullable String name1, @Nullable String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return SystemInfoRt.isFileSystemCaseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    public static int compareFiles(@Nullable File file1, @Nullable File file2) {
        return FileUtil.comparePaths(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static int comparePaths(@Nullable String path1, @Nullable String path2) {
        return OSAgnosticPathUtil.COMPARATOR.compare(path1, path2);
    }

    public static int fileHashCode(@Nullable File file2) {
        return FileUtilRt.pathHashCode((String)(file2 == null ? null : file2.getPath()));
    }

    public static int pathHashCode(@Nullable String path) {
        return FileUtilRt.pathHashCode((String)path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        return Strings.toLowerCase(FileUtilRt.getExtension((String)fileName));
    }

    @NotNull
    @NlsSafe
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        try {
            return SystemInfoRt.isWindows && FileUtil.containsWindowsShortName(path) ? Paths.get(path, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString() : path;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public static boolean containsWindowsShortName(@NotNull String path) {
        if (path.indexOf(126) < 0) {
            return false;
        }
        path = FileUtil.toSystemIndependentName(path);
        int start = 0;
        while (start < path.length()) {
            int dot;
            int end = path.indexOf(47, start);
            if (end < 0) {
                end = path.length();
            }
            if ((dot = path.lastIndexOf(46, end)) < start) {
                dot = end;
            }
            if (dot - start > 2 && dot - start <= 8 && end - dot - 1 <= 3 && path.charAt(dot - 2) == '~' && Character.isDigit(path.charAt(dot - 1))) {
                return true;
            }
            start = end + 1;
        }
        return false;
    }

    @Nullable
    public static String extractRootPath(@NotNull String normalizedPath) {
        int sc;
        if (SystemInfoRt.isWindows) {
            int p1;
            if (OSAgnosticPathUtil.startsWithWindowsDrive(normalizedPath)) {
                return StringUtil.toUpperCase(normalizedPath.substring(0, 2));
            }
            if (normalizedPath.startsWith("//") && (p1 = normalizedPath.indexOf(47, 2)) > 2) {
                int p2 = normalizedPath.indexOf(47, p1 + 1);
                if (p2 > p1 + 1) {
                    return normalizedPath.substring(0, p2);
                }
                if (p2 < 0) {
                    return normalizedPath;
                }
            }
        } else if (StringUtil.startsWithChar(normalizedPath, '/')) {
            return "/";
        }
        if ((sc = normalizedPath.indexOf("://")) != -1) {
            return normalizedPath.substring(0, sc + "://".length());
        }
        return null;
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> outFiles) {
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(@NotNull File absoluteRoot, @NotNull File root, @NotNull Pattern pattern, @NotNull List<? super File> files2) {
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath(absoluteRoot, dir);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName(relativePath)).matches()) continue;
                files2.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files2);
        }
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        return FileUtil.convertAntToRegexp(antPattern, true);
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        StringBuilder builder = new StringBuilder();
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        return builder.toString();
    }

    public static boolean moveDirWithContent(@NotNull File fromDir, @NotNull File toDir) {
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files2 = fromDir.listFiles();
        if (files2 == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files2) {
            File toFile2 = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile2);
        }
        fromDir.delete();
        return success;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name) {
        return FileUtil.sanitizeFileName(name, true);
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict) {
        return FileUtil.sanitizeFileName(name, strict, "_");
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict, @NotNull String replacement) {
        StringBuilder result = null;
        int last = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                if (strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-') {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result == null) {
                result = new StringBuilder();
            }
            if (last < i) {
                result.append(name, last, i);
            }
            if (appendReplacement) {
                result.append(replacement);
            }
            last = i + 1;
        }
        if (result == null) {
            return name;
        }
        if (last < length) {
            result.append(name, last, length);
        }
        return result.toString();
    }

    public static boolean canExecute(@NotNull File file2) {
        return file2.canExecute();
    }

    public static boolean canWrite(@NotNull String path) {
        FileAttributes attributes = FileSystemUtil.getAttributes(path);
        return attributes != null && attributes.isWritable();
    }

    public static void setReadOnlyAttribute(@NotNull String path, boolean readOnlyFlag) {
        boolean writableFlag;
        boolean bl = writableFlag = !readOnlyFlag;
        if (!new File(path).setWritable(writableFlag, false) && FileUtil.canWrite(path) != writableFlag) {
            LOG.warn("Can't set writable attribute of '" + path + "' to '" + readOnlyFlag + "'");
        }
    }

    public static void appendToFile(@NotNull File file2, @NotNull String text) throws IOException {
        FileUtil.writeToFile(file2, text.getBytes(StandardCharsets.UTF_8), true);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] content) throws IOException {
        FileUtil.writeToFile(file2, content, false);
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text) throws IOException {
        FileUtil.writeToFile(file2, text, false);
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text, @NotNull Charset charset) throws IOException {
        FileUtil.writeToFile(file2, text.getBytes(charset));
    }

    public static void writeToFile(@NotNull File file2, @NotNull String text, boolean append) throws IOException {
        FileUtil.writeToFile(file2, text.getBytes(StandardCharsets.UTF_8), append);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] content, int off, int len) throws IOException {
        FileUtil.writeToFile(file2, content, off, len, false);
    }

    public static void writeToFile(@NotNull File file2, byte @NotNull [] content, boolean append) throws IOException {
        FileUtil.writeToFile(file2, content, 0, content.length, append);
    }

    private static void writeToFile(@NotNull File file2, byte @NotNull [] content, int off, int len, boolean append) throws IOException {
        FileUtil.createParentDirs(file2);
        try (FileOutputStream stream = new FileOutputStream(file2, append);){
            ((OutputStream)stream).write(content, off, len);
        }
    }

    @NotNull
    public static JBTreeTraverser<File> fileTraverser(@Nullable File root) {
        return (JBTreeTraverser)Lazy.FILE_TRAVERSER.withRoot(root);
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor) {
        return FileUtil.fileTraverser(root).bfsTraversal().processEach(processor);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<? super File> processor, @Nullable Processor<? super File> directoryFilter) {
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children2;
            File file2 = (File)queue.removeFirst();
            if (!processor.process(file2)) {
                return false;
            }
            if (directoryFilter != null && (!file2.isDirectory() || !directoryFilter.process(file2)) || (children2 = file2.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children2);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        for (String path : paths) {
            File file2;
            if (Strings.isEmptyOrSpaces(path) || !(file2 = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    public static List<File> findFilesByMask(@NotNull Pattern pattern, @NotNull File dir) {
        ArrayList<File> found = new ArrayList<File>();
        File[] files2 = dir.listFiles();
        if (files2 != null) {
            for (File file2 : files2) {
                if (file2.isDirectory()) {
                    found.addAll(FileUtil.findFilesByMask(pattern, file2));
                    continue;
                }
                if (!pattern.matcher(file2.getName()).matches()) continue;
                found.add(file2);
            }
        }
        return found;
    }

    @NotNull
    public static List<File> findFilesOrDirsByMask(@NotNull Pattern pattern, @NotNull File dir) {
        ArrayList<File> found = new ArrayList<File>();
        File[] files2 = dir.listFiles();
        if (files2 != null) {
            for (File file2 : files2) {
                if (pattern.matcher(file2.getName()).matches()) {
                    found.add(file2);
                }
                if (!file2.isDirectory()) continue;
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file2));
            }
        }
        return found;
    }

    @Nullable
    @NlsSafe
    public static String findFileInProvidedPath(@NotNull String providedPath, String ... fileNames) {
        File file2;
        if (Strings.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && ArrayUtil.indexOf(fileNames, providedFile.getName()) >= 0) {
            return FileUtil.toSystemDependentName(providedFile.getPath());
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file2 = new File(providedFile, fileName);
                if (!fileName.equals(file2.getName()) || !file2.exists()) continue;
                return FileUtil.toSystemDependentName(file2.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file2 = new File(providedFile, fileName);
                if (!fileName.equals(file2.getName()) || !file2.exists()) continue;
                return FileUtil.toSystemDependentName(file2.getPath());
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isAbsolutePlatformIndependent(@NotNull String path) {
        return FileUtil.isUnixAbsolutePath(path) || FileUtil.isWindowsAbsolutePath(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isUnixAbsolutePath(@NotNull String path) {
        return path.startsWith("/");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isWindowsAbsolutePath(@NotNull String path) {
        return path.length() <= 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) || OSAgnosticPathUtil.isAbsoluteDosPath(path);
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String getLocationRelativeToUserHome(@Nullable String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @NlsSafe
    public static String getLocationRelativeToUserHome(@Nullable String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfoRt.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    @Contract(pure=true)
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        return path;
    }

    public static File @NotNull [] notNullize(File @Nullable [] files2) {
        return FileUtil.notNullize(files2, ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    public static File @NotNull [] notNullize(File @Nullable [] files2, File @NotNull [] defaultFiles) {
        return files2 == null ? defaultFiles : files2;
    }

    public static boolean isHashBangLine(@Nullable CharSequence firstCharsIfText, @NotNull String marker) {
        if (firstCharsIfText == null) {
            return false;
        }
        if (!StringUtil.startsWith(firstCharsIfText, "#!")) {
            return false;
        }
        int lineBreak = Strings.indexOf(firstCharsIfText, '\n', 2);
        return lineBreak >= 0 && Strings.indexOf(firstCharsIfText, marker, 2, lineBreak) != -1;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory((String)prefix, (String)suffix);
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempDirectory((String)prefix, (String)suffix, (boolean)deleteOnExit);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempDirectory((File)dir, (String)prefix, (String)suffix);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempDirectory((File)dir, (String)prefix, (String)suffix, (boolean)deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile((String)prefix, (String)suffix);
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempFile((String)prefix, (String)suffix, (boolean)deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        return FileUtilRt.createTempFile((File)dir, (String)prefix, (String)suffix);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create) throws IOException {
        return FileUtilRt.createTempFile((File)dir, (String)prefix, (String)suffix, (boolean)create);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create, boolean deleteOnExit) throws IOException {
        return FileUtilRt.createTempFile((File)dir, (String)prefix, (String)suffix, (boolean)create, (boolean)deleteOnExit);
    }

    @NotNull
    @NlsSafe
    public static String getTempDirectory() {
        return FileUtilRt.getTempDirectory();
    }

    @TestOnly
    public static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        FileUtilRt.resetCanonicalTempPathCache((String)tempPath);
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        return FileUtilRt.generateRandomTemporaryPath();
    }

    public static void setExecutable(@NotNull File file2) throws IOException {
        NioFiles.setExecutable(file2.toPath());
    }

    @Nullable
    public static String loadFileOrNull(@NotNull String path) {
        return FileUtil.loadFileOrNull(new File(path));
    }

    @Nullable
    public static String loadFileOrNull(@NotNull File file2) {
        try {
            return FileUtil.loadFile(file2);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file2) throws IOException {
        return FileUtilRt.loadFile((File)file2);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile((File)file2, (boolean)convertLineSeparators);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadFile((File)file2, (String)encoding);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @NotNull Charset encoding) throws IOException {
        return String.valueOf(FileUtilRt.loadFileText((File)file2, (Charset)encoding));
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile((File)file2, (String)encoding, (boolean)convertLineSeparators);
    }

    public static char @NotNull [] loadFileText(@NotNull File file2) throws IOException {
        return FileUtilRt.loadFileText((File)file2);
    }

    public static char @NotNull [] loadFileText(@NotNull File file2, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadFileText((File)file2, (String)encoding);
    }

    public static char @NotNull [] loadText(@NotNull Reader reader, int length) throws IOException {
        return FileUtilRt.loadText((Reader)reader, (int)length);
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2) throws IOException {
        return FileUtilRt.loadLines((File)file2);
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadLines((File)file2, (String)encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        return FileUtilRt.loadLines((String)path);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadLines((String)path, (String)encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        return FileUtilRt.loadLines((BufferedReader)reader);
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream) throws IOException {
        return FileUtilRt.loadBytes((InputStream)stream);
    }

    public static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        return FileUtilRt.loadBytes((InputStream)stream, (int)length);
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path) {
        return FileUtil.splitPath((String)path, (char)File.separatorChar);
    }

    public static boolean visitFiles(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (!processor.process(root)) {
            return false;
        }
        File[] children2 = root.listFiles();
        if (children2 != null) {
            for (File child : children2) {
                if (FileUtil.visitFiles(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteWithRenamingIfExists(@NotNull Path file2) {
        return Files.exists(file2, new LinkOption[0]) && FileUtil.deleteWithRenaming(file2);
    }

    public static boolean deleteWithRenaming(@NotNull Path file2) {
        return FileUtil.deleteWithRenaming(file2.toFile());
    }

    public static boolean deleteWithRenaming(@NotNull File file2) {
        File tempFileNameForDeletion = FileUtil.findSequentNonexistentFile(file2.getParentFile(), file2.getName(), "");
        boolean success = file2.renameTo(tempFileNameForDeletion);
        return FileUtil.delete(success ? tempFileNameForDeletion : file2);
    }

    public static boolean isFileSystemCaseSensitive(@NotNull String path) throws FileNotFoundException {
        FileAttributes attributes = FileSystemUtil.getAttributes(path);
        if (attributes == null) {
            throw new FileNotFoundException(path);
        }
        FileAttributes upper = FileSystemUtil.getAttributes(Strings.toUpperCase(path));
        FileAttributes lower = FileSystemUtil.getAttributes(Strings.toLowerCase(path));
        return !attributes.equals(upper) || !attributes.equals(lower);
    }

    @NotNull
    public static String getUrl(@NotNull File file2) {
        try {
            return file2.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return "file://" + file2.getAbsolutePath();
        }
    }

    @NotNull
    public static URI fileToUri(@NotNull File file2) {
        return FileUtilRt.fileToUri((File)file2);
    }

    private static class Lazy {
        private static final JBTreeTraverser<File> FILE_TRAVERSER = JBTreeTraverser.from(file2 -> file2 == null ? Collections.emptySet() : JBIterable.of(file2.listFiles()));

        private Lazy() {
        }
    }
}

