/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;

public final class FileFilters {
    public static final FileFilter EVERYTHING = file2 -> true;
    public static final FileFilter DIRECTORIES = file2 -> file2.isDirectory();

    private FileFilters() {
    }

    public static FileFilter withExtension(@NotNull String extension) {
        return pathname -> FileUtilRt.extensionEquals((String)pathname.getPath(), (String)extension);
    }

    public static FileFilter filesWithExtension(@NotNull String extension) {
        return pathname -> FileUtilRt.extensionEquals((String)pathname.getPath(), (String)extension) && pathname.isFile();
    }
}

