/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class ProperTextRange
extends TextRange {
    public ProperTextRange(int startOffset, int endOffset) {
        super(startOffset, endOffset);
    }

    public ProperTextRange(@NotNull TextRange range) {
        this(range.getStartOffset(), range.getEndOffset());
    }

    @Override
    @NotNull
    public ProperTextRange cutOut(@NotNull TextRange subRange) {
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        return new ProperTextRange(this.getStartOffset() + subRange.getStartOffset(), Math.min(this.getEndOffset(), this.getStartOffset() + subRange.getEndOffset()));
    }

    @Override
    @NotNull
    public ProperTextRange shiftRight(int delta) {
        if (delta == 0) {
            return this;
        }
        return new ProperTextRange(this.getStartOffset() + delta, this.getEndOffset() + delta);
    }

    @Override
    @NotNull
    public ProperTextRange grown(int lengthDelta) {
        if (lengthDelta == 0) {
            return this;
        }
        return new ProperTextRange(this.getStartOffset(), this.getEndOffset() + lengthDelta);
    }

    @Override
    public ProperTextRange intersection(@NotNull TextRange range) {
        ProperTextRange.assertProperRange(range);
        int newStart = Math.max(this.getStartOffset(), range.getStartOffset());
        int newEnd = Math.min(this.getEndOffset(), range.getEndOffset());
        return ProperTextRange.isProperRange(newStart, newEnd) ? new ProperTextRange(newStart, newEnd) : null;
    }

    @Override
    @NotNull
    public ProperTextRange union(@NotNull TextRange textRange) {
        ProperTextRange.assertProperRange(textRange);
        TextRange range = super.union(textRange);
        return new ProperTextRange(range);
    }

    @NotNull
    public static ProperTextRange create(@NotNull Segment segment) {
        return new ProperTextRange(segment.getStartOffset(), segment.getEndOffset());
    }

    @NotNull
    public static ProperTextRange create(int startOffset, int endOffset) {
        return new ProperTextRange(startOffset, endOffset);
    }

    @NotNull
    public static ProperTextRange from(int offset, int length) {
        return new ProperTextRange(offset, offset + length);
    }
}

