/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = new Reference2ObjectOpenHashMap();
    private final Map<Disposable, Object> myDisposedObjects = CollectionFactory.createWeakIdentityMap(100, 0.5f);
    private final Object treeLock = new Object();
    private final ObjectNode ROOT_NODE = ObjectNode.createRoot();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        return this.myObject2NodeMap.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RuntimeException register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == child) {
            return new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            ObjectNode parentNode;
            RuntimeException e;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                return new IncorrectOperationException("Sorry but parent: " + parent + " (" + parent.getClass() + ") has already been disposed (see the cause for stacktrace) so the child: " + child + " (" + child.getClass() + ") will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            this.myDisposedObjects.remove(child);
            if (child instanceof Disposer.CheckedDisposableImpl) {
                ((Disposer.CheckedDisposableImpl)child).isDisposed = false;
            }
            if ((e = this.checkWasNotAddedAlreadyAsChild(parentNode = this.getOrCreateParentNode(parent), childNode = this.getOrCreateChildNode(parentNode, child))) != null) {
                return e;
            }
            parentNode.addChild(childNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private RuntimeException checkWasNotAddedAlreadyAsChild(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        for (ObjectNode node = childNode; node != this.ROOT_NODE; node = node.getParent()) {
            if (node != parentNode) continue;
            return new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
        return null;
    }

    @NotNull
    private ObjectNode getOrCreateParentNode(@NotNull Disposable parent) {
        return this.myObject2NodeMap.computeIfAbsent(parent, p -> new ObjectNode((Disposable)p, this.ROOT_NODE));
    }

    @NotNull
    private ObjectNode getOrCreateChildNode(@NotNull ObjectNode parentNode, @NotNull Disposable child) {
        return this.myObject2NodeMap.compute(child, (c, oldNode) -> {
            if (oldNode == null) {
                oldNode = new ObjectNode((Disposable)c, parentNode);
            } else {
                ObjectNode oldParent = oldNode.getParent();
                oldParent.removeChild((ObjectNode)oldNode);
            }
            return oldNode;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull Supplier<? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        boolean bl = needTrace = Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
        if (needTrace) {
            ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
        }
        Object object = this.treeLock;
        synchronized (object) {
            disposables = removeFromTreeAction.get();
        }
        SmartList<Throwable> exceptions = null;
        for (int i = disposables.size() - 1; i >= 0; --i) {
            Disposable disposable = disposables.get(i);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(t);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAllChildren(@NotNull Disposable object, @Nullable Predicate<? super Disposable> predicate) {
        this.runWithTrace(() -> {
            ObjectNode node = this.getNode(object);
            if (node == null) {
                return Collections.emptyList();
            }
            ArrayList disposables = new ArrayList();
            node.getAndRemoveChildrenRecursively(this, disposables, predicate);
            return disposables;
        });
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        this.runWithTrace(() -> {
            ObjectNode node = this.getNode(object);
            if (node == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node == null) {
                if (this.rememberDisposedTrace(object) == null) {
                    disposables.add(object);
                }
            } else {
                node.getAndRemoveRecursively(this, disposables);
            }
            return disposables;
        });
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        ProcessCanceledException processCanceledException = null;
        for (Throwable throwable : exceptions) {
            if (!(throwable instanceof ProcessCanceledException)) {
                ObjectTree.getLogger().error(throwable);
                continue;
            }
            if (processCanceledException != null) continue;
            processCanceledException = (ProcessCanceledException)throwable;
        }
        if (processCanceledException != null) {
            throw processCanceledException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        Object object = this.treeLock;
        synchronized (object) {
            for (ObjectNode node : this.myObject2NodeMap.values()) {
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ROOT_NODE.assertNoChildren(throwError);
        }
    }

    Throwable getRegistrationTrace(@NotNull Disposable object) {
        ObjectNode objectNode = this.getNode(object);
        return objectNode == null ? null : objectNode.getTrace();
    }

    @NotNull
    static Logger getLogger() {
        return Logger.getInstance(ObjectTree.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object rememberDisposedTrace(@NotNull Disposable object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            return this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.treeLock;
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value : this.myObject2NodeMap.values()) {
                value.clearTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObjectFromTree(@NotNull ObjectNode node) {
        Object object = this.treeLock;
        synchronized (object) {
            Disposable myObject = node.getObject();
            this.myObject2NodeMap.remove(myObject);
            ObjectNode parent = node.getParent();
            parent.removeChild(node);
        }
    }
}

