/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectNode {
    private ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private Throwable myTrace;
    private static final Disposable ROOT_DISPOSABLE = Disposer.newDisposable();

    ObjectNode(@NotNull Disposable object, @NotNull ObjectNode parentNode) {
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode.isRoot() && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private ObjectNode() {
        this.myObject = ROOT_DISPOSABLE;
        this.myParent = this;
    }

    void assertNoChildren(boolean throwError) {
        if (this.myChildren != null) {
            for (ObjectNode childNode : this.myChildren) {
                if (childNode == null) continue;
                Disposable object = childNode.getObject();
                Throwable trace = childNode.getTrace();
                String message = "Memory leak detected: '" + object + "' of " + object.getClass() + " is registered in Disposer but wasn't disposed.\nRegister it with a proper parentDisposable or ensure that it's always disposed by direct Disposer.dispose call.\nSee https://jetbrains.org/intellij/sdk/docs/basics/disposers.html for more details.\nThe corresponding Disposer.register() stacktrace is shown as the cause:\n";
                RuntimeException exception = new RuntimeException(message, trace);
                if (throwError) {
                    throw exception;
                }
                ObjectTree.getLogger().error(exception);
            }
        }
    }

    private boolean isRoot() {
        return this.myObject == ROOT_DISPOSABLE;
    }

    @NotNull
    static ObjectNode createRoot() {
        return new ObjectNode();
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children2 = this.myChildren;
        if (children2 == null) {
            this.myChildren = new SmartList<ObjectNode>(child);
        } else {
            children2.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children2 = this.myChildren;
        if (children2 != null) {
            for (int i = children2.size() - 1; i >= 0; --i) {
                ObjectNode node = children2.get(i);
                if (!node.equals(child)) continue;
                children2.remove(i);
                break;
            }
        }
    }

    @NotNull
    ObjectNode getParent() {
        return this.myParent;
    }

    void getAndRemoveRecursively(@NotNull ObjectTree myTree, @NotNull List<? super Disposable> result) {
        this.getAndRemoveChildrenRecursively(myTree, result, null);
        myTree.removeObjectFromTree(this);
        if (myTree.rememberDisposedTrace(this.myObject) == null) {
            result.add(this.myObject);
        }
        this.myChildren = null;
        this.myParent = null;
    }

    void getAndRemoveChildrenRecursively(@NotNull ObjectTree myTree, @NotNull List<? super Disposable> result, @Nullable Predicate<? super Disposable> predicate) {
        if (this.myChildren != null) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                ObjectNode childNode = this.myChildren.get(i);
                if (predicate != null && !predicate.test(childNode.getObject())) continue;
                childNode.getAndRemoveRecursively(myTree, result);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    @TestOnly
    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode node : this.myChildren) {
                node.assertNoReferencesKept(aDisposable);
            }
        }
    }
}

